#!/bin/sh
export MOPAC_LICENSE=$HOME/MOPAC
export MOPAC_EXECUTABLE=MOPAC2012.exe
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$MOPAC_LICENSE
export COEFS_TEMPLATE="template.coefs"
export MOPAC_TEMPLATE="template.mop"
export MOPAC_MOP="mopac_input.mop"
export EXTERNAL_INPUT="mopac.input"
export EXTERNAL_FIT="mopac.fit"
export EXTRACTED_DATA="extracted.data"
export BOUNDS_FILE="bounds.txt"

injector $1 bulk

if [ "$1" -ne "0" ]
then
	shepherd
	extractor $1
	fitter $1 $EXTRACTED_DATA $EXTERNAL_FIT
else
	mkbounds 10
fi
