/*
 (c)GAFit toolkit $Id: utils.c 510 2025-04-22 14:23:13Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>

#include "core.h"
#include "rand.h"
#include "evaluation.h"
#include "numbers.h"
#include "job.h"
#include "utils.h"

void
copia_ind (p_ind or, p_ind dest, int ind_size)
{
  int i;
  dest->fitness = or->fitness;
  for (i = 0; i < ind_size; i++)
    dest->genes[i] = or->genes[i];
}

void
initializeNewPopulation (JOB * jo)
{

  // allocates memory for individuals (to generate the new population)
  jo->new_population = malloc (sizeof (ind) * jo->pop_size);
  for (int i = 0; i < jo->pop_size; i++)
    {
      jo->new_population[i].genes = malloc (sizeof (double) * jo->N);
    }
}

int
initializePopulation (JOB * jo)
{
  int j, i;

  // allocates memory for individuals
  jo->population = malloc (sizeof (ind) * jo->pop_size);
  for (i = 0; i < jo->pop_size; i++)
    {
      jo->population[i].genes = malloc (sizeof (double) * jo->N);
    }

  // make individual
  for (i = 0; i < jo->pop_size; i++)
    {
      j = 0;
      while (j < jo->N)
	{
	  if (!isInt (jo->bounds[j].decimals))
	    {
	      jo->population[i].genes[j] =
		jo->bounds[j].min +
		(uniform01 () * (jo->bounds[j].max - jo->bounds[j].min));
	    }

	  else
	    jo->population[i].genes[j] =
	      random_number (jo->bounds[j].min, jo->bounds[j].max);
	  j++;
	}
      jo->population[i].fitness = 0.0;
    }

  //best
  jo->best.genes = malloc (sizeof (double) * jo->N);
  jo->new_best.genes = malloc (sizeof (double) * jo->N);

  //evaluation of first population
  return evaluate_OldPop (jo);
}


void
decimalPlaces (JOB * jo, p_ind pop)
{
  int i, j;
  for (i = 0; i < jo->pop_size; i++)
    {
      for (j = 0; j < jo->N; j++)
	{
	  ///***************decimal places*****************
	  if (jo->bounds[j].decimals < DECIMAL_PLACES)
	    {
	      pop[i].genes[j] =
		cutDecimals (pop[i].genes[j], jo->bounds[j].decimals);
	    }
	  ///**********************************************
	}
    }
}
