/*
 (c)GAFit toolkit $Id: stats.c 510 2025-04-22 14:23:13Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include "core.h"
#include "job.h"
#include "stats.h"
#include "utils.h"

int last_print;

void
update_all_time_best (JOB * jo)
{
  int i;
  FILE *bestfile;
  if (jo->dir == 1)
    {
      //must be <= to write the very first time
      if (jo->best.fitness >= jo->all_time_best.fitness)
	{
	  copia_ind (&jo->best, &jo->all_time_best, jo->N);
	  if ((bestfile = fopen (OUTPUT_BEST, "w")) == NULL)
	    {
	      printf ("\nerror: can't open file for best individual.\n");
	      exit (EXIT_FAILURE);
	    }
	  for (i = 0; i < jo->N; i++)
	    {
	      fprintf (bestfile, "%12.12f\n", jo->best.genes[i]);
	    }
	  fprintf (bestfile, "\nFitness: %g\n", jo->best.fitness);
	  fclose (bestfile);
	}
    }

  else
    {
      //must be <= to write the very first time
      if (jo->best.fitness <= jo->all_time_best.fitness)
	{
	  copia_ind (&jo->best, &jo->all_time_best, jo->N);
	  if ((bestfile = fopen (OUTPUT_BEST, "w")) == NULL)
	    {
	      printf ("\nerror: can't open file for best individual.\n");
	      exit (EXIT_FAILURE);
	    }
	  for (i = 0; i < jo->N; i++)
	    {
	      fprintf (bestfile, "%12.12f\n", jo->best.genes[i]);
	    }
	  fprintf (bestfile, "\nFitness: %g\n", jo->best.fitness);
	  fclose (bestfile);
	}
    }
}


// Statistics 
void
stats (JOB * j, int generation, int evals)
{
  static int PrintHeader = 1;
  int i;
  double average = 0.0;
  FILE *output;

  for (i = 0; i < j->pop_size; i++)
    {
      average += j->population[i].fitness;
    }

  output = fopen (OUTPUT_FILE, "at");
  if (PrintHeader)
    {
      fprintf (output, "\nEval.\tGen.\tAverage/population\tBest fit.\n");
      fprintf (output,
	       "------------------------------------------------------\n");
    }
  fprintf (output, "%d\t%d\t%g\t\t\t%g\t", evals,
	   generation, average / j->pop_size, j->best.fitness);
  fputc ('\n', output);
  fclose (output);
  //if (GetPrintRun ())
  if (j->print_run)
    {
      if (PrintHeader)
	{
	  printf ("\n");
	  printf ("Eval.\t\tBest fit.\n");
	  printf ("------------------------------------\n");
	}
      printf ("%d\t\t%g\t", evals, j->best.fitness);
      putchar ('\n');
    }
  PrintHeader = 0;
}

void
avg_stats (int runs, int exec_time, int dir)
{

  //int total_iter;
  FILE *fil, *out;
  int i, j;
  char out_nome[50];
  double avg_fit, best_fit, best, worst;
  int gen, evals, num_best;
  struct res tab[MAX_LIN];
  fil = fopen (OUTPUT_FILE, "rt");
  if (!fil)

    {
      return;
    }
  strcpy (out_nome, "avg_");
  strcat (out_nome, OUTPUT_FILE);
  out = fopen (out_nome, "wt");
  //** only for shut up warnings
  // no inititialize needed
  best = 0;
  worst = 0;
  num_best = 0;
  j = 0;
  //******************************                              
  for (i = 0; i < runs; i++)
    {
      fscanf (fil, " run %*d");
      if (i == 0)
	fprintf (out, "Last lines\n");
      j = 0;
      while (fscanf
	     (fil, " %d %d %lf %lf", &evals, &gen, &avg_fit, &best_fit) == 4)
	{
	  if (i == 0)
	    {
	      tab[j].gen = gen;
	      tab[j].evals = evals;
	      tab[j].avg_fit = avg_fit;
	      tab[j].best_fit = best_fit;
	    }
	  else
	    {
	      tab[j].gen += gen;
	      tab[j].evals += evals;
	      tab[j].avg_fit += avg_fit;
	      tab[j].best_fit += best_fit;
	    }
	  j++;
	  if (j >= MAX_LIN)
	    {
	      fclose (fil);
	      fprintf (out, "\ntoo many lines in input\n");
	      fclose (out);
	      return;
	    }
	}
      fprintf (out, "%10d%10d\t%12.12f\t%12.12f\n", evals, gen,
	       avg_fit, best_fit);
      if (dir == 1)
	{
	  if (i == 0)
	    {
	      best = best_fit;
	      worst = best_fit;
	      num_best = 1;
	    }
	  else
	    {
	      if (best_fit > best)
		{
		  best = best_fit;
		  num_best = 1;
		}

	      else if (best_fit == best)
		num_best++;

	      else if (best_fit < worst)
		worst = best_fit;
	    }
	}

      else
	{
	  if (i == 0)
	    {
	      best = best_fit;
	      worst = best_fit;
	      num_best = 1;
	    }
	  else
	    {
	      if (best_fit < best)
		{
		  best = best_fit;
		  num_best = 1;
		}

	      else if (best_fit == best)
		num_best++;

	      else if (best_fit > worst)
		worst = best_fit;
	    }
	}
    }
  fprintf (out, "\nEvolution of results\n");
  for (i = 0; i < j; i++)

    {
      fprintf (out, "%10d%10d\t%12.12f\t%12.12f\n",
	       tab[i].evals / runs, tab[i].gen / runs,
	       tab[i].avg_fit / runs, tab[i].best_fit / runs);
    }
  fprintf (out,
	   "\nBest: %12.12f (found in %d runs)\tWorst: %12.12f\n",
	   best, num_best, worst);
  int h, m, seg;
  seg = exec_time % 60;
  exec_time = exec_time / 60;
  m = exec_time % 60;
  h = exec_time / 60;
  fprintf (out, "\nExecution time: %d:%d:%d\n", h, m, seg);
  fclose (fil);
  fclose (out);
}
