/*
 (c)GAFit toolkit $Id: selection.c 510 2025-04-22 14:23:13Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include "job.h"
#include "rand.h"
#include "utils.h"
#include "selection.h"
ind
get_best (JOB * jo)
{
  int i;
  ind best = jo->population[0];
  if (jo->dir == 1)
    {
      for (i = 1; i < jo->pop_size; i++)
	{
	  if (jo->population[i].fitness > best.fitness)
	    best = jo->population[i];
	}
    }

  else
    {
      for (i = 1; i < jo->pop_size; i++)
	{
	  if (jo->population[i].fitness < best.fitness)
	    best = jo->population[i];
	}
    }
  return best;
}


int
get_worst (JOB * jo)
{
  int i;
  int worst = 0;
  if (jo->dir == 1)
    {
      for (i = 1; i < jo->pop_size; i++)
	{
	  if (jo->population[i].fitness < jo->population[worst].fitness)
	    {
	      worst = i;
	    }
	}
    }

  else
    {
      for (i = 1; i < jo->pop_size; i++)
	{
	  if (jo->population[i].fitness > jo->population[worst].fitness)
	    {
	      worst = i;
	    }
	}
    }
  return worst;
}


// replaces a random individual with the best from previous generation
void
apply_elite (JOB * jo, ind best)
{
  copia_ind (&best, jo->population + get_worst (jo), jo->N);
}

// tournament selection
void
tournament_selection (JOB * jo)
{
  int i, j, index, winner;	// individual chosen by tournament

  // make new population with tournament winners
  for (i = 0; i < jo->pop_size; i++)
    {

      // chose individual after tournament of size K
      winner = random_number (0, jo->pop_size - 1);
      for (j = 1; j < jo->ga.size_k; j++)
	{
	  index = random_number (0, jo->pop_size - 1);
	  if (jo->dir == 1)
	    {
	      if (jo->population[index].fitness >
		  jo->population[winner].fitness)
		winner = index;
	    }

	  else
	    {
	      if (jo->population[index].fitness <
		  jo->population[winner].fitness)
		winner = index;
	    }
	}
      copia_ind (jo->population + winner, jo->new_population + i, jo->N);
    }
}
