/*
(c) GAFit toolkit $Id: rstrings.c 539 2025-05-31 22:22:16Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include "rstrings.h"


//isblank: space or tab
char *
sRtrim (char *s)
{
  char *p = s + strlen (s);
  while (isblank (*--p));
  *(p + 1) = '\0';
  return s;
}

//isblank: space or tab
// this can be changed, 
// move first the pointer for 
// the first not blank, and
// do bcopy.
char *
sLtrim (char *s)
{
  while (isblank (*s))
    {
      bcopy (s + 1, s, strlen (s + 1) + 1);
    }
  return s;
}

//isspace: space, form-feed ('\f'), newline ('\n'), carriage return ('\r'), horizontal tab ('\t'), and vertical tab ('\v').
char *
sSRtrim (char *s)
{
  char *p = s + strlen (s);
  while (isspace (*--p));
  *(p + 1) = '\0';
  return s;
}

//isspace: space, form-feed ('\f'), newline ('\n'), carriage return ('\r'), horizontal tab ('\t'), and vertical tab ('\v').
//the same as sLtrim
char *
sSLtrim (char *s)
{
  while (isspace (*s))
    {
      bcopy (s + 1, s, strlen (s + 1) + 1);
    }
  return s;
}

//isspace: space, form-feed ('\f'), newline ('\n'), carriage return ('\r'), horizontal tab ('\t'), and vertical tab ('\v').
void *
rsTSpace (char *s)
{
  char *p = s;
  while (*p)
    {
      if (isspace (*p))
	*p = ' ';
      p++;
    }
  return s;
}

//isspace: space, form-feed ('\f'), newline ('\n'), carriage return ('\r'), horizontal tab ('\t'), and vertical tab ('\v').
int
isBlankLine (char *s)
{
  char *p = s;
  while (*p)
    {
      if (!isspace (*p))
	return 0;
      p++;
    }
  return 1;
}

char *
sLowerCase (char *l)
{
  char *p;
  p = l;
  while (*p)
    {
      *p = (char) tolower (*p);
      p++;
    }
  return l;
}

char *
sUpperCase (char *l)
{
  char *p;
  p = l;
  while (*p)
    {
      *p = (char) toupper (*p);
      p++;
    }
  return l;
}

int
sStr2Double (const char *str, double *a)
{
  char *ptr;

  errno = 0;

  *a = strtod (str, &ptr);

  if (*ptr != '\0' && ptr != str)
    {
      //could be a float
      if (*ptr == 'e' && isdigit (*(ptr - 1)))
	return ISFLOAT;

      //there are only trailing spaces...???
      while (*ptr == ' ')
	ptr++;
      if (*ptr == '\0')
	return ISFLOAT;

      printf ("Syntax error here \"%s\", extra characters:\"%s\"\n", str,
	      ptr);
      exit (EXIT_FAILURE);
    }
  if (*ptr != '\0' || ptr == str)
    return NONUMBER;
  if ((errno == ERANGE && (*a == HUGE_VALF || *a == HUGE_VALL))
      || (errno != 0 && *a == 0))
    return NONUMBER;

  return ISNUMBER;
}


char *
sInsString (char *str, char point, char *str2)
{
  char *a;
  char *ret;
  char *tmp;
  int len;
  a = rindex (str, point);
  len = strlen (str) + 2 + strlen (str2);
  ret = (char *) malloc (sizeof (char) * len);
  ret = strcpy (ret, str);
  if (!a)
    {				// no insertion point
      //add TAG at the end
      ret[strlen (str) + 1] = '\0';
      ret[strlen (str)] = point;
      ret = strcat (ret, str2);
    }
  else
    {
      a = a + 1;
      tmp = (char *) malloc (sizeof (char) * strlen (a) + 1);
      tmp = strcpy (tmp, a);
      a = rindex (ret, point);
      strcpy (a + 1, str2);
      ret[strlen (ret) + 1] = '\0';
      ret[strlen (ret)] = point;
      ret = strcat (ret, tmp);
      free (tmp);
    }
  return ret;
}

char *
sReplaceString (char *s, char *search, char *replace)
{
  char *p, *q, *r;
  int inc = strlen (replace) - strlen (search);
  while ((strstr (s, search)))
    {
      if (inc > 0)
	s = (char *) realloc (s, (strlen (s) + inc + 1) * sizeof (char));
      p = strstr (s, search);
      r = p + strlen (search);
      q = (char *) malloc (sizeof (char) * strlen (r) + 1);
      strcpy (q, r);
      strcpy (r + inc, q);
      free (q);
      strncpy (p, replace, strlen (replace));
    }
  return s;
}

char *
sInt2Ascii (int i)
{
  char *s = malloc (MAX_SIZE_DECIMAL_INTEGER (int));
  sprintf (s, "%d", i);
  return s;
}

// clone string padding center
// must be freed after use
char *
fws (int width, char *string)
{
  char *clone = malloc (sizeof (char) * (width + 1));
  char *p;
  memset (clone, ' ', width);
  clone[width] = '\0';
  int l = strlen (string);
  p = clone + ((width - l) / 2 + 1);
  for (int i = 0; i < l; i++)
    {
      p[i] = string[i];
    }
  return clone;
}
