/*
(c) GAFit toolkit $Id: rangecf.h 393 2021-08-15 11:41:40Z ro $
*/

#ifndef _ANALYZE_COEFS__
#define _ANALYZE_COEFS__

#define LPAREN "("
#define RPAREN ")"
#define COMMA ","
#define SCOLON ";"
#define DOT "."
#define SPACE " "
#define TAB "\t"
#define COLON ":"
#define ASTERISK "*"
#define VBAR "|"
#define AT "@"
#define BANG "!"
#define NSIGN "#"
#define SLASH "/"

#define TYPE_CHOICE "c"
#define TYPE_INTEGER "i"
#define TYPE_DOUBLE "d"

#define DECIMALS_CHOICE "0"
#define DECIMALS_INTEGER "0"
#define DECIMALS_DOUBLE "9"

#define ANALYSIS_RESULTS_FILE "template-analysis"

#define AT_LINE_MAX 1024



typedef struct
{
  char **strings;
  char **names;			//coefficients names
  char **format;
  char **types;
  char **limits;
  char **llimit;
  char **ulimit;
  char **choice;
  char **decimals;
  char **coefs;			//coefficient order
  int ncoefs;
} RANGECOEFS;


RANGECOEFS *rcFactory (void);
void rcDelete (RANGECOEFS * r);

RANGECOEFS *rcAnalyzeString (char *s);
RANGECOEFS *rcAnalyzeTemplate (char *inTemplate, char *outAnalisys);
RANGECOEFS *rcReadAnalysisResults (char *arfile);

int rcWriteResponse (RANGECOEFS * rc, char *etype, char *einput, char *efit,
		     char *bounds);
int rcWriteBounds (RANGECOEFS * rc, char *bounds, char *origintemplate);
int rcWriteAnalysisResults (RANGECOEFS * rc, char *outFile);
char *rcCreateParameters (char *t, double *coefs, RANGECOEFS * rc);

char *rcGetChoice (int i, int value, RANGECOEFS * rc);
const char *rcGetType (int i, RANGECOEFS * rc);

void rcTemplateClean (RANGECOEFS * rc);
void rcStringClean (RANGECOEFS * rc);

#endif
