/*
 (c)GAFit toolkit $Id: rand.c 429 2023-12-22 00:17:04Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <math.h>
#include "rand.h"


void
saveSeed (unsigned int seed)
{
  FILE *f = fopen (RANDOM_SAVE_FILE, "w");
  fprintf (f, "%u", seed);
  fclose (f);

}

char *
init_rand (unsigned int test, char *txt)
{
  unsigned int seed;

  sleep (1);			//at least 1 sec difference with previous seed

  if (test)
    {
      srand (test);
      snprintf (txt, TEXT_RANDOM_SIZE, "TEST MODE seed: %u", test);
      seed = test;
    }
  else
    {
      seed = (unsigned) time (NULL);
      snprintf (txt, TEXT_RANDOM_SIZE, "this run's seed:%u", seed);
      srand (seed);
    }
  saveSeed (seed);
  return txt;
}

// flips coin with probability p
int
flip (double p)
{
  if ((((float) rand ()) / RAND_MAX) < p)
    {
      return 1;
    }
  else
    {
      return 0;
    }
}


// generates a random integer for a given limit
int
random_number (int low, int high)
{
  return low + rand () % (high - low + 1);
}


// Uniform distribution
double
uniform01 ()
{
  return (double) (((double) rand ()) / ((double) RAND_MAX));
}

// Normal distribution N(0,1)   
double
normal01 ()
{
  static int flag = 0;
  static double x1;
  double u1, u2, v1, v2, square;
  double r;
  if (flag == 0)
    {

      do
	{
	  u1 = uniform01 ();
	  u2 = uniform01 ();
	  v1 = 2.0 * u1 - 1.0;
	  v2 = 2.0 * u2 - 1.0;
	  r = v1 * v1 + v2 * v2;
	}
      while (r >= 1.0 || r == 0.0);
      flag = 1;
      square = sqrt (-2.0 * log (r) / r);
      x1 = v1 * square;
      return v2 * square;
    }
  else
    {
      flag = 0;
      return x1;
    }
}
