/*
(c) GAFit toolkit $Id: parameters.h 539 2025-05-31 22:22:16Z ro $
*/
#
#ifndef __PARAMETERS__
#define __PARAMETERS__
/* Generic routines to scan config files.
   A config-file is splited into [SECTIONS] in any order or empty.
      note->Only the config-file must itself exist (empty is ok).
   A section could contain any parameters in any order or empty.
   Each parameter has a default which is returned if not found 
      or it is out of set (GetFromSetParameter)

Config-file example:
----------------8<----------------
[SECTION 1]
parameter1: value1
parameter2: value2

[EMPTY SECTION]

[SECTION HELLO WORLD]
helloworld : string hello world!
integer   : 10
bool:yes
----------------8<----------------
All requested parameters from the "empty section" will be defaults.
There are some working examples in "finput.c".
*/

int GetIntParameter (char *file, char *section, char *parameter,
		     int intdefault);
unsigned int GetUIntParameter (char *file, char *section, char *parameter,
			       unsigned int intdefault);
double GetDblParameter (char *file, char *section, char *parameter,
			double dbldefault);
int GetStringParameter (char *file, char *section, char *parameter,
			char *chardefault, char *dest, int destlen);
int GetBoolParameter (char *file, char *section, char *parameter,
		      int booldefault);
int GetFromSetParameter (char *file, char *section, char *parameter,
			 char *ValidSetList[], int IndexOfValidListDefault,
			 int ulcase);
char *SectionText (const char *file, const char *section);

int ParameterSet2int (char *string, char *list[]);

#endif
