/*
(c) GAFit toolkit $Id: parameters.c 539 2025-05-31 22:22:16Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../inputline/line.h"
#include "../rstrings/rstrings.h"
#include "../flyctl/flyctl.h"
#include "parameters.h"
/*
  see parameters.h
  */


char *
SectionText (const char *file, const char *section)
{
  char *s;
  FILE *f;
  char *lwsection;
  char *a, *b;
  char *text;
  int issec = 0;
  int secline = 0;
  f = fopen (file, "r");
  lwsection = sLowerCase (strdup (section));
  if (f)
    {
      text = (char *) malloc (sizeof (char));
      *text = '\0';
      while ((s = InputFileLine (f)) != NULL)
	{
	  a = index (s, '[');
	  b = index (s, ']');
	  secline = (a != NULL && b != NULL);
	  if (issec && !secline)
	    {
	      text =
		(char *) realloc (text,
				  (strlen (s) + strlen (text) +
				   2) * sizeof (char));
	      text = strcat (text, s);
	      text = strcat (text, "\n");
	    }

	  if (secline)
	    {
	      memmove (s, a + 1, b - a - 1);
	      s[b - a - 1] = '\0';
	      s = sLowerCase (s);
	      if (strcmp (s, lwsection) == 0)
		issec = 1;
	      else
		issec = 0;
	    }
	  free (s);
	}
      fclose (f);
      if (strlen (text) > 0)
	return text;
      free (text);
    }
  free (lwsection);
  return NULL;
}

char *
SearchParameters (const char *file, const char *section, const char *item)
{
  char *s;
  FILE *f;
  char *a, *b;
  int issec = 0;
  f = fopen (file, "r");
  if (f)
    {
      while ((s = InputFileLine (f)) != NULL)
	{
	  if ((a = index (s, '[')) != NULL)
	    if ((b = index (s, ']')) != NULL)
	      {
		memmove (s, a + 1, b - a - 1);
		s[b - a - 1] = '\0';
		s = sLowerCase (s);
		if (strcmp (s, section) == 0)
		  issec = 1;
		else
		  issec = 0;
	      }
	  if (issec)
	    {
	      if ((a = index (s, ':')) != NULL)
		{
		  *a = '\0';
		  b = a + 1;
		  b = sLtrim (sRtrim (b));
		  s = sLtrim (sRtrim (s));
		  s = sLowerCase (s);
		  if (strcmp (item, s) == 0)
		    {
		      a = strdup (b);
		      free (s);
		      fclose (f);
		      return a;
		    }
		}
	    }
	  free (s);
	}
      fclose (f);
    }
  return NULL;
}

int
GetIntParameter (char *file, char *section, char *item, int intdefault)
{
  char *s;
  int ret;
  s = SearchParameters (file, section, item);
  if (s)
    ret = atoi (s);
  else
    ret = intdefault;
  free (s);
  return ret;
}

unsigned int
GetUIntParameter (char *file, char *section, char *item,
		  unsigned int intdefault)
{
  char *s;
  unsigned int ret;
  s = SearchParameters (file, section, item);
  if (s)
    ret = (unsigned int) atoll (s);	//note this: to long, not to usigned int!!
  else
    ret = intdefault;
  free (s);
  return ret;
}

double
GetDblParameter (char *file, char *section, char *item, double dbldefault)
{
  char *s;
  double ret;
  s = SearchParameters (file, section, item);
  if (s)
    ret = atof (s);
  else
    ret = dbldefault;
  free (s);
  return ret;
}

/**
 * Get a string parameter from a configuration file.
 * @parameter file the configuration file
 * @parameter section the section in configuration file
 * @parameter item the parameter to search to
 * @chardefault default value if not found
 * @dest string where to copy the value
 * @mlen the max length of the dest string.
 * 
 * @return 1 if found, 0 if not, and returns the default value.
 */

int
GetStringParameter (char *file, char *section, char *item, char *chardefault,
		    char *dest, int mlen)
{
  char *s;
  s = SearchParameters (file, section, item);
  if (s)
    {
      strncpy (dest, s, mlen);
      free (s);
      return 1;
    }
  else
    {
      strncpy (dest, chardefault, mlen);
      return 0;
    }
}

int
GetBoolParameter (char *file, char *section, char *item, int booldefault)
{
  char *s;
  int ret = 0;
  s = SearchParameters (file, section, item);
  //DEBUG
  //printf("gbp:[%s]\n",s);
  //DEBUG
  if (s)
    {
      if (strcmp (s, "yes") == 0 || atoi (s) != 0)
	ret = 1;
      else if (strcmp (s, "no") == 0)
	ret = 0;
    }
  else
    ret = booldefault;
  free (s);
  return ret;
}

///
/// ulcase: 0, case insensitive
///
int
GetFromSetParameter (char *file, char *section, char *item, char *list[],
		     int indexdefault, int ulcase)
{
  char *s;
  int n = 0;
  int ret = -1;
  s = SearchParameters (file, section, item);
  if (s)
    {
      if (!ulcase)
	s = sLowerCase (s);
      while (*list)
	{
	  if (strcmp (*list, s) == 0)
	    ret = n;
	  list++;
	  n++;
	}
    }
  if (ret == -1)
    ret = indexdefault;
  free (s);
  return ret;
}

///
/// number of option parameter to parameter string
///
int
ParameterSet2int (char *string, char *list[])
{
  int r = 0;
  while (list[r])
    {
      if (strcmp (list[r], string) == 0)
	return r;
      ++r;
    }
  fcPrintfStopIt ("Option unknown: %s\n", string);
  return 0;
}
