/*
(c) GAFit toolkit $Id: pack.c 24 2015-02-10 23:50:10Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <limits.h>
#include <errno.h>
#include "pack.h"
#include "../bytecodes/bytecodes.h"

double
str2double (char *string)
{
  char *end;
  errno = 0;
  double n = strtod (string, &end);
  if (n == 0)
    {
      if (string == end)
	{
	  fprintf (stderr, "str2double cannot parse %s\n", string);
	  exit (EXIT_FAILURE);
	}
    }
  if (errno == ERANGE)
    {
      perror ("str2double out of range\n");
      exit (EXIT_FAILURE);
    }
  if (*end != '\0')
    {
      fprintf (stderr, "str2double cannot parse %s \n", end);
      exit (EXIT_FAILURE);
    }

  return n;
}

long
str2long (char *string)
{
  char *end;
  errno = 0;
  long n = strtol (string, &end, 10);

  if (errno == ERANGE)
    {
      perror ("str2long out of range \n");
      exit (EXIT_FAILURE);
    }

  if (end == string)
    {
      fprintf (stderr, "str2long cannot parse %s \n", string);
      exit (EXIT_FAILURE);
    }

  if (*end != '\0')
    {
      fprintf (stderr, "str2long cannot parse %s \n", end);
      exit (EXIT_FAILURE);
    }

  return n;
}

void *
String2Cast (enum PACKTYPE Cast, char *s)
{
  void *ret = packBuff ();

  switch (Cast)
    {
    case BYTECODE:
      *(enum BYTECODE *) ret = (enum BYTECODE) str2long (s);
      break;
    case INT:
      *(int *) ret = (int) str2long (s);
      break;
    case CHAR:
      *(char *) ret = (char) str2long (s);
      break;
    case LONG:
      *(long *) ret = str2long (s);
      break;
    case FLOAT:
      *(float *) ret = (float) str2double (s);
      break;
    case DOUBLE:
      *(double *) ret = str2double (s);
      break;
    case END:
      *(enum BYTECODE *) ret = END;
      break;
    default:
      exit (EXIT_FAILURE);
    }
  return ret;
}


int
unitLen (enum PACKTYPE c)
{
  switch (c)
    {
    case BYTECODE:
      return sizeof (enum BYTECODE);
      break;
    case INT:
      return sizeof (int);
      break;
    case CHAR:
      return sizeof (char);
      break;
    case LONG:
      return sizeof (long);
      break;
    case FLOAT:
      return sizeof (float);
      break;
    case DOUBLE:
      return sizeof (double);
      break;
    case END:
      return 0;
      break;
    default:
      exit (EXIT_FAILURE);
    }
}

void *
pack (enum PACKTYPE c, void *s, void *v, int *len)
{
  int plen;
  char a;

  plen = unitLen (c);

  s = (void *) realloc (s, *len + sizeof (char));
  a = (char) c;
  bcopy ((void *) &a, s + *len, sizeof (char));
  *len += sizeof (char);
  s = (void *) realloc (s, *len + plen);
  bcopy ((void *) v, s + *len, plen);
  *len += plen;
  return s;
}


enum PACKTYPE
upack (void *s, int *pos, void *var)
{
  char c;
  int plen;
  void *ret;

  c = *(char *) (s + *pos);
  ret = s + *pos + sizeof (char);
  switch (c)
    {
    case BYTECODE:
      plen = sizeof (enum BYTECODE);
      *((enum BYTECODE *) var) = (enum BYTECODE) *(enum BYTECODE *) ret;
      break;
    case INT:
      plen = sizeof (int);
      *((int *) var) = (int) *(int *) ret;
      break;
    case CHAR:
      plen = sizeof (char);
      *((char *) var) = (char) *(char *) ret;
      break;
    case LONG:
      plen = sizeof (long);
      *((long *) var) = (long) *(long *) ret;
      break;
    case FLOAT:
      plen = sizeof (float);
      *((float *) var) = (float) *(float *) ret;
      break;
    case DOUBLE:
      plen = sizeof (double);
      *((double *) var) = (double) *(double *) ret;
      break;
    case END:
      plen = 0;
      *((int *) var) = (int) *(int *) s;
      break;
    default:
      exit (EXIT_FAILURE);
    }
  *pos += sizeof (char) + plen;
  return c;
}

void *
packBuff (void)
{
  return (void *) malloc (MAXPACKBUFF);
}

void
printPack (void *s)
{
  void *buffer = packBuff ();
  enum PACKTYPE type;
  int pos;

  pos = 0;

  do
    {
      type = upack (s, &pos, buffer);
      switch (type)
	{
	case BYTECODE:
	  printf ("\n\t%s", byteCodeString (*(enum BYTECODE *) buffer));
	  break;
	case CHAR:
	  printf (" char %c", *(char *) buffer);
	  break;
	case INT:
	  printf (" int %d", *(int *) buffer);
	  break;
	case LONG:
	  printf (" long %ld", *(long *) buffer);
	  break;
	case FLOAT:
	  printf (" float %f", *(float *) buffer);
	  break;
	case DOUBLE:
	  printf (" double %lf", *(double *) buffer);
	  break;
	case END:
	  printf ("\n\tend\n");
	  break;
	default:
	  printf ("type %d error", type);
	  exit (EXIT_FAILURE);

	}
    }
  while (type != END);
  free (buffer);
}
