/*
 (c)GAFit toolkit $Id: numbers.c 322 2018-03-28 14:46:56Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>
#include <stdio.h>

#include "numbers.h"

char *
ii (int i)
{
  static char *a = "integer";
  static char b[30];
  b[0] = '\0';
  if (isInt (i))
    return a;
  if (i <= DECIMAL_PLACES)
    {
      if (i == 1)
	sprintf (b, "real, 1 decimal");
      else
	sprintf (b, "real, %d decimals", i);
    }
  else
    sprintf (b, "real");
  return b;
}

int
isInt (int decimals)
{
  if (decimals == 0)
    return 1;
  return 0;
}

/**
  * x double to cut
  * r number of decimal places
  * return x cutted.
  **/
double
cutDecimals (double x, int r)
{
  if (r > 0 && r < DECIMAL_PLACES)
    {
      double a = pow (10, r);
      return trunc (x * a) / a;
    }
  return x;
}
