/*
 * (c) GAFit toolkit $Id: mvtest.c 328 2018-07-31 16:19:38Z ro $
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <math.h>


#include "mvcommon.h"
#include "../rangecf/rangecf.h"
#include "../inputline/line.h"
#include "../flyctl/flyctl.h"
#include "../nullist/nllist.h"
#include "../parameters/parameters.h"
#include "../rstrings/rstrings.h"
#include "../compiler/ucompiler.h"
#include "../fpu/fpu.h"
#include "../core.h"

extern char **AllColumnsTokens;

int
main (int argc, char *argv[])
{
//we only use job.txt to configure the job. No environment variables here.
  char fitvar[MAXSTR];
  char einput[MAXSTR], efit[MAXSTR];
  char **prgmvars;
  char **datavariables, **varstype;
//  int column = 0;

  RANGECOEFS *rc;

  if (argc > 2 || (argc == 2 && strcmp (argv[1], "-h") == 0))
    {
      printf ("\nmvtest v0.1 (c)GAFit toolkit - 2015\n");
      printf ("\tUsage: %s [coefficient-file]\n\n", argv[0]);

    }
  else
    {
      mvReadConfiguration (einput, efit, fitvar,
			   &prgmvars, &varstype, &datavariables);
      if (argc == 2)
	{
	  if (FileExist (argv[1]))
	    {
	      strcpy (einput, argv[1]);
	    }
	  else
	    {
	      finito ("file doesn't exist");
	    }
	}
      else
	{
	  strcpy (einput, "best.txt");
	}

      rc = rcReadAnalysisResults (ANALYSIS_RESULTS_FILE);
      mvMachineGun (1, rc, einput, efit, fitvar,
		    prgmvars, varstype, datavariables, argc);
      nllClear (datavariables);
      nllClear (prgmvars);
      nllClear (varstype);
      nllClear (AllColumnsTokens);
      rcDelete (rc);
    }
}
