/*
 * (c) GAFit toolkit $Id: mvariable.c 328 2018-07-31 16:19:38Z ro $
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <math.h>


#include "mvcommon.h"
#include "../rangecf/rangecf.h"
#include "../inputline/line.h"
#include "../flyctl/flyctl.h"
#include "../nullist/nllist.h"
#include "../parameters/parameters.h"
#include "../rstrings/rstrings.h"
#include "../compiler/ucompiler.h"
#include "../fpu/fpu.h"
#include "../core.h"

extern char **AllColumnsTokens;

int
main (int argc, char *argv[])
{
  int indv;
//we only use job.txt to configure the job. No environment variables here.
  char job[] = "job.txt";
  char fitvar[MAXSTR], data[MAXSTR], columns[MAXSTR], expression[MAXSTR];
  char einput[MAXSTR], efit[MAXSTR], ebounds[MAXSTR];
  int headers, pasm;
  char *text;
  char **asmcode, **prgmvars;
  char **datavariables, **varstype;
  char **tmp;
  char *coefficients, *l;
  RANGECOEFS *rc;

  coefficients = malloc (sizeof (char) * MAXSTR);

  if (argc != 2)
    {
      printf ("\nMulti Variables v0.1 (c)GAFit toolkit - 2015\n");
      printf ("\tUsage: %s number-of-vectors\n\n", argv[0]);
      finito ("mvariable: number of arguments");
    }

  indv = atoi (argv[1]);
  if (indv == 0)		//system configuration
    {
      fcStartFly ();
      if (!mvGetJobParameters (job, einput, efit, ebounds))
	{
	  finito ("Not configured to external auto");
	}

      if ((text =
	   mvGetParameters (job, coefficients, fitvar,
			    data, columns, expression,
			    &headers, &pasm, MAXSTR)) != NULL)
	{
	  printf ("Mvariable Analysis\n");
	  printf ("============================\n");
	  printf ("external inp: %s\n", einput);
	  printf ("external fit: %s\n", efit);
	  printf ("bounds file : %s\n", ebounds);
	  if (index (coefficients, '(') == NULL)
	    {
	      l = SectionText (job, coefficients);
	      rsTSpace (l);
	      l = sRtrim (sLtrim (l));
	      printf ("coefficients: %s = [", coefficients);
	      free (coefficients);
	      coefficients = l;
	      mvPrintPrettyCoeffs (l);
	      printf ("]\n\n");
	    }
	  else
	    {
	      printf ("coefficients: %s\n", coefficients);
	    }
	  printf ("fit variable: %s\n", fitvar);
	  printf ("data file   : %s\n", data);
	  printf ("columns     : %s\n", columns);
	  printf ("headers     : %d\n", headers);
	  printf ("expression  : %s\n", expression);
	  printf ("print code  : %s\n", pasm ? "yes" : "no");
	  text = sLtrim (sRtrim (text));
	  mvPrintPrettyExpr (text);
	  //compile expression
	  asmcode = uCompile (text, BINARY_NAME, &prgmvars);
	  free (text);
	  if (asmcode)
	    {
	      if (pasm)
		{
		  //there is asm code as compilation result
		  //saved as mvprog.usm too.
		  //binary is saved as mvprog.uxe
		  //prgmvars is loaded with the variables in the
		  //correct memory order to pass a memory block
		  //to uFPU.
		  printf ("Compiler result:\n");
		  prettyPrintAsm (asmcode);
		}
	      nllClear (asmcode);
	      //is the fit variable used in the code?
	      if (nllLocate (fitvar, prgmvars) < 0)
		{
		  finito ("fit variable useless");
		}
	      //are any data column used in the expression?
	      datavariables = nllParser (columns, ColumnsTokens);
	      datavariables = nllDelete (datavariables, AllColumnsTokens);
	      tmp = nllListInter (datavariables, prgmvars);
	      if (!tmp)
		{
		  finito ("Data file is useless");
		}
	      nllClear (tmp);
	      if ((rc = rcAnalyzeString (coefficients)) != NULL)
		{
		  if (rcWriteAnalysisResults (rc, ANALYSIS_RESULTS_FILE) != 0)
		    {
		      if (rcWriteBounds (rc, ebounds, job) != 0)
			{
			  if (rcWriteResponse
			      (rc, EXTERNAL_TYPE_BULK, einput, efit,
			       ebounds) != 0)
			    {
			      //Classify variables
			      varstype =
				ClassifyVars (prgmvars, rc, datavariables);
			      mvParseData (data, headers, datavariables,
					   varstype);
			      mvSaveConfiguration (einput, efit, fitvar,
						   prgmvars, varstype,
						   datavariables);
			      nllClear (datavariables);
			      nllClear (prgmvars);
			      nllClear (varstype);
			      nllClear (AllColumnsTokens);
			      free (coefficients);
			      //printf ("============================\n");
			    }
			  else
			    {
			      finito ("Write response failed\n");
			    }
			}
		      else
			{
			  finito ("Write bounds failed\n");
			}
		    }
		  else
		    {
		      finito ("Write analysis results failed\n");
		    }
		}
	      else
		{
		  finito ("Analyze failed");
		}
	    }
	  else
	    {
	      finito ("Unsuccessfull compilation");
	    }
	}
      else
	{
	  finito ("no text in expression");
	}
    }
  else				//system run
    {
      mvReadConfiguration (einput, efit, fitvar,
			   &prgmvars, &varstype, &datavariables);
      rc = rcReadAnalysisResults (ANALYSIS_RESULTS_FILE);
      mvMachineGun (indv, rc, einput, efit, fitvar,
		    prgmvars, varstype, datavariables, 0);
      nllClear (datavariables);
      nllClear (prgmvars);
      nllClear (varstype);
      nllClear (AllColumnsTokens);
    }
  rcDelete (rc);
}
