/*
 (c)GAFit toolkit $Id: mutation.c 510 2025-04-22 14:23:13Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>
#include "numbers.h"
#include "evaluation.h"
#include "core.h"
#include "job.h"
#include "mutation.h"

#define MAX_TRY 5


double
mutate_integer (double val, domain d, int mutin)
{
  double new_val;

  if (d.gap <= 1.0)
    return val;

  if (mutin == 0)
    {
      do
	{
	  new_val = random_number (d.min, d.max);
	}
      while (new_val == val);
    }
  else
    {
      if (val == d.min)
	new_val = val + 1.0;
      else if (val == d.max)
	new_val = val - 1.0;
      else if (flip (0.5))
	new_val = val + 1.0;
      else
	new_val = val - 1.0;
    }

  return new_val;
}


void
random_mutation (double individual[], int pop_size, int ind_size,
		 vect_domain bounds, double p_mt, int mutin)
{
  int pos;

  for (pos = 0; pos < ind_size; pos++)
    {
      if (flip (p_mt) == TRUE)
	{
	  if (!isInt (bounds[pos].decimals))
	    individual[pos] =
	      bounds[pos].min +
	      (uniform01 () * (bounds[pos].max - bounds[pos].min));
	  else
	    individual[pos] =
	      mutate_integer (individual[pos], bounds[pos], mutin);
	}
    }
}



void
sigma_mutation (double individual[], int pop_size, int ind_size,
		vect_domain bounds, double p_mt, double sigma, int mutin)
{
  int pos, conta;
  double new_val, ni;

  for (pos = 0; pos < ind_size; pos++)
    {
      if (flip (p_mt) == TRUE)
	{
	  if (!isInt (bounds[pos].decimals))
	    {
	      conta = 0;
	      do
		{
		  ni = normal01 ();
		  new_val =
		    individual[pos] + sigma * (bounds[pos].max -
					       bounds[pos].min) * ni;
		  conta++;
		  if (conta > MAX_TRY)
		    {
		      new_val =
			bounds[pos].min +
			(uniform01 () * (bounds[pos].max - bounds[pos].min));
		      break;
		    }
		}
	      while (new_val < bounds[pos].min || new_val > bounds[pos].max);
	      individual[pos] = new_val;
	    }
	  else
	    individual[pos] =
	      mutate_integer (individual[pos], bounds[pos], mutin);
	}
    }
}

void
apply_mutation (JOB * jo)
{
  int i;
  for (i = 0; i < jo->pop_size; i++)
    {
      switch (jo->ga.mutation_type)
	{
	case 0:
	  random_mutation (jo->new_population[i].genes, jo->pop_size, jo->N,
			   jo->bounds, jo->ga.p_mt, jo->ga.mutation_integer);
	  break;
	case 1:
	  sigma_mutation (jo->new_population[i].genes, jo->pop_size, jo->N,
			  jo->bounds, jo->ga.p_mt, jo->ga.sigma,
			  jo->ga.mutation_integer);
	  break;
	default:
	  printf ("Invalid mutation type\n");
	  exit (EXIT_FAILURE);
	  break;
	}
    }
}
