/*
   (c) GAFit toolkit $Id: regpots.h 468 2024-06-20 22:07:19Z ro $
*/

#ifndef __REG_POTS__
#define __REG_POTS__

#include "../flyctl/flyctl.h"

#define FortranSetupPots  fsetuppots_
#define FRegisterPot registerpot_
#define FCStopIt cstopit_

/*
 * system
 * geometry
 * atom a
 * atom b
 * distance
 * number of coeffs
 * coeffs vector
 */
//typedef double (*FPOINTER) (int, int, int, int, double, int, double *);

/*
 * system
 * geometry
 * number of atoms
 * atoms vector
 * number of distances
 * distance vector
 * number of coeffs
 * coeffs vector
 * */
typedef double (*FPOINTER) (int, int, int, int *, int, double *, int,
			    double *);

typedef struct
{
  int n;			// number of registered potentials
  char **name;			// list of names (not null terminated)
  int *npot;			// registered potential numbers
  int *ncoefs;			// numbers of coefficients
  char *lang;			// programming language (f->fortran, c->C, ...)
  char *kind;			// '2' body or '3' body functions.
  FPOINTER *funcs;		// pointers to potential functions.
} POTS;


void FortranSetupPots (void);	// call to fortran
void CSetupPots (void);		// C call

void FRegisterPot (char *name, int *npot, int *ncoefs, char *t, long n, long m);	// call back from fortran to C to register pots.
void CRegisterPot (char *name, FPOINTER f, int ncoefs, char t);	// call back from C to C to register pots.

void InitPot ();		// callee from C to any lang

void setPotential (char kind, char *name);	// sets current potential

char **definedPots (char kind);	// list (not null terminated!!!) of defined pots.
int getPotCoefs (char kind);	// potential coefficients' number 
int getPotNumber (char kind);	// current potential number
char getPotLang (char kind);	// potential's programming language
FPOINTER getPotFunctionC (char kind);	// C potential pointer
int getPotFunctionF (char kind);	// Fortran potential number
void printPots (void);		// prints known potentials (registered ones).

void FCStopIt (char *msg, long n);	// flyctl call to stop job
#endif
