/*
(c) GAFit toolkit $Id: multijob.h 562 2025-12-11 15:34:12Z ro $
*/

#ifndef _MULTIJOB_
#define _MULTIJOB_

#define DATA_FILE "multi.data"

#define DUMP_DATA_FILE "dump-multi.data"

#define DEFAULT_DEBUG 0

#define DEFAULT_3B_INTERACTIONS 0

#define DEFAULT_SUMMARY 0

#define INPUT_FILE_INTJOB "job.txt"

#define WRITE 0

#define APPEND 1

#define FortranFunctionRouter frouter_

#define DATA_END "END"

#define DATA_DATA "DATA"

typedef struct
{
  int typea;
  int typeb;
  int typec;
  char *str;
} TBODYINT;

typedef struct
{
  int typea;
  int typeb;
  char *str;
} DBODYINT;

typedef struct
{
  char *potential_name;		// three body potential
  int potential;		// three body potential number
  int ncoefs;			// coeficients per interaction
  char *external_bounds;	// 3body bounds file
  int rcoefs;			// bounds: all or repeat
  int N;			// number of 3body coefficients, count3body x ncoefs 
  int count3body;		// 3body interactions number.
  vect_domain bounds;		// 3body bounds.
  TBODYINT *tbodyint;		// 3body distinct interactions order list.  
  int ***type2intCube;		// type to interactions matrix MULTIJOB dtypes x dtypes x dtypes
} TBODY;

typedef struct
{				//this info is mainly duplicate 
  char *hbg_name;
  int n_types;			// number of atoms in group
  char **a_types;		//atom's type string a_types[n_types]
} HBGROUP;

typedef struct
{
  int n_atoms;			// number of atoms in each system: multijob->data[i]->n
  int frag;			// n atoms in fragment A. multijob->data[i]->frag
  int *hb_coef;			// hb coef if used, none = 0, maps atom to hb coef
  char **atoms;			// atom's string
  char **types;			// atom's type string
  int *type_n;			// atom's type number
  char *labels_block;		// atoms block to pass to fortran. 
  int *ilabels_block;		// atom's number block to pass to fortran
  int ne;			// number of geometries multijob->data[]->ne
  double **geo;			// geometries to pass to fortran,
} HBSYSTEMS;

typedef struct
{
  char *external_bounds;	// hb bounds file
  int rcoefs;			// bounds: all or repeat
  int ncoefs;			// number of hb coefficients, is the number of hbgroups 
  int N;			// number of hb coefficients: ncoefs x 1
  int countHb;			// interaction number=1
  vect_domain bounds;		// Hb bounds
  HBGROUP **hb_groups;		// groups of atom types to asociate with hb coefs
  int nsys;			// it's multijob->nsys; 
  HBSYSTEMS **hbsys;		// one for each system
  int kind;			// all, intra, inter
  int debug;			// print extra info for debugging 
} HBONDS;

typedef struct
{				//this info is mainly duplicate 
  char *phbg_name;
  int n_types;			// number of atoms in group
  char **a_types;		//atom's type string a_types[n_types]
} PHBGROUP;

typedef struct
{
  int n_atoms;			// number of atoms in each system: multijob->data[i]->n
  int frag;			// n atoms in fragment A. multijob->data[i]->frag
  int **phb_coef;		// phb coef if used, none = 0, maps atom pairs to hb coef
  char **atoms;			// atom's string
  char **types;			// atom's type string
  int *type_n;			// atom's type number
  char **pg_name;		// atom group string
  int *pg_n;			// atom group number
  char *labels_block;		// atoms block to pass to fortran. 
  int *ilabels_block;		// atom's number block to pass to fortran
  int ne;			// number of geometries multijob->data[]->ne
  double **geo;			// geometries to pass to fortran,
} PHBSYSTEMS;


typedef struct
{
  char *external_bounds;	// phb bounds file
  int rcoefs;			// bounds: all or repeat
  int ncoefs;			// number of phb coefficiens, the number of hb pairs
  int N;			// number of phb coeficients: ncoefs x 1
  vect_domain bounds;		// phb bounds
  PHBGROUP **phb_groups;	// phb group of atoms of interest 
  int n_groups;			// phb numer of groups
  int *dtypes2agroup;		// maps dtypes to php atom groups
  // 0 means atom not in groups
  int **pairsMat;		// pair's matrix atoms groups x atoms groups                
  int countPhb;			// interactions pairs
  char **phbStrings;		// interactions pairs string
  // till here, replication cases above.
  int nsys;			// it's multijob->nsys
  PHBSYSTEMS **phbsys;		// one for each system
  int kind;			// all, intra, inter ??
  int debug;			// print extra info for debugging 
} PHBONDS;

typedef struct
{
  char **atom;			// atom list
  double *x;			// x list
  double *y;			// y list
  double *z;			// z list
} GEOMETRY;			// geometry.

typedef struct
{
  int frag;			// n atoms in fragment A.
  int n;			// total atoms in system.
  char **a2tatom;		// atom2type atom name.
  char **a2ttype;		// atom2type type text.
  int *a2tntype;		// atom2type type number.
  int ntypea;			// n types in a.
  char **dtypea;		// types in a string.
  int ntypeb;			// n types in b.
  char **dtypeb;		// types in b string. 
  int ne;			// number of energies=geometries.
  double *energies;		// energies for each geometry.
  double *weigth;		// weight.
  GEOMETRY **geos;		// geometries.
} SYSTEM;

typedef struct
{
  JOB *job;			// JOB from job.h
  int debug;			// debug mode
  int msummary;			// if msummary -> print machine readable summary
  int potential;		// potential.
  char *potential_name;		// potential name.  
  int fitting;			// fitting. See core.h.
  //int potcoef;        job->ncoefs             // Potential coefs.
  int rcoefs;			// Bounds: all or repeat.
  int nsys;			// number of systems.
  char **systems;		// name of the systems.
  char **geometries;		// geometry files.
  char **energies;		// energy files.
  char **atom2type;		// atom2type files.
  SYSTEM **data;		// system data
  int dtypes;			// distinct atom types.
  char **types;			// list of distinct atom types.
  int count2body;		// number of 2body interactions.
  int *interactions;		// interaction vector.
  DBODYINT *dbodyint;		// two body interactions data recopilation
  // on load saved
  //   ***************** 3 BODY **************************
  int tbinteractions;		// three body interactions
  TBODY *tbody;			// three body data
  //   ***************** H BONDS *************************
  int hbinteractions;
  HBONDS *hbonds;
  //   ***************** PHBONDS ************************
  int phbinteractions;
  PHBONDS *phbonds;
  // ****************** coeficient vector ***************
  double *vec_coeffs;
  // ****************** tmp contributions ***************
  double contrib_2body;
  double contrib_3body;
  double contrib_hbonds;
}
MULTIJOB;

MULTIJOB *nwmj (void);

//fortran code
double FortranFunctionRouter (int *fn, int *system, int *geo, int *na,
			      int *atoms, int *nr, double *r, int *nc,
			      double *vc);
int NC (MULTIJOB * j);

void dimGeom (MULTIJOB * j);
void dimInterVector (MULTIJOB * j);
void dimData (MULTIJOB * j);

int mat2vec (MULTIJOB * j, int ro, int co);

void printMultiBanner (MULTIJOB * J);
void printTypes (MULTIJOB * j);
void printInteractions (MULTIJOB * j);

void readAtom2Type (MULTIJOB * j);

void readEnergies (MULTIJOB * j);
void printEnergies (MULTIJOB * j);

void readGeometries (MULTIJOB * j);
void printGeometries (MULTIJOB * j);
void printAll (MULTIJOB * j);

void loadData (MULTIJOB * j, char *file);
void saveData (MULTIJOB * j, char *file);


double functionCaller (int system, int geo, int atoma, int atomb, int debug);
double function3Caller (int system, int geo, int atoma, int atomb, int atomc,
			int debug);

double eval_multi (MULTIJOB * j, double *genes);
double EvalGeo (MULTIJOB * j, int system, int geo);
double fitGeo (MULTIJOB * j, int system, int geo);

void mReadBounds (MULTIJOB * j);

char *ReadCoefs (int how);
void setCNames (MULTIJOB * j, int ncoefs2plus3);

void setDebug (MULTIJOB * j, int how);
void MultiAnalyzer (MULTIJOB * j);
int type2num (char *type, MULTIJOB * j);
#endif
