/*
(c) GAFit toolkit $Id: multi.c 479 2024-07-01 17:30:29Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../flyctl/flyctl.h"
#include "../job.h"
#include "../inputline/line.h"
#include "regpots.h"
#include "multijob.h"
#include "multi.h"
#include "final.h"

char *ExternalType = NULL;


int
main (int argc, char **argv)
{
  MULTIJOB *j;

  int indv;
  char *p = NULL;

  j = nwmj ();

  fcStartFly ();
  if (!FileExist (j->job->file))
    {
      fcStopIt ("no job file\n");
    }

  if (argc == 1)
    {
      printf ("\n%s v0.3 (c)GAFit toolkit - 2021,2024\n", argv[0]);
      printf ("\tUsage: %s number-of-vectors [bulk]\n\n", argv[0]);
      exit (EXIT_SUCCESS);
    }
  else if (argc > 3)
    {
      printf ("Error!\n");
      fcStopIt ("multi intermolecular: number of arguments\n");
    }
  else
    {
      if (argc == 3)
	{
	  if (!(strcmp (argv[2], "bulk")))
	    p = EXTERNAL_TYPE_BULK;
	  else
	    printf ("Error: defaults to external\n");
	}
      if (!p)
	p = EXTERNAL_TYPE_NORMAL;
      ExternalType = (char *) malloc ((strlen (p) + 1) * sizeof (char));
      strcpy (ExternalType, p);
      indv = atoi (argv[1]);

      InitEnvironmentVariables (j->job);
      InitPot ();
      if (indv == 0)
	{
	  MultiAnalyzer (j);
	  mReadBounds (j);
	  WriteResponse (j);
	}
      else if (indv > 0)
	{
	  loadData (j, DATA_FILE);
	  unlink ("response");
	  RunEvaluation (indv, j);
	}
      else
	{
	  loadData (j, DATA_FILE);
	  printf ("\n#\n#FinalEvaluation\n#");
	  FinalEvaluation (stdout, j);
	}
    }
  fflush (stdout);
}
