! hbwrapper   

double precision function hbwrapper(natoms,atom,ilabels,param_list,geoxyz,frag,kind,debug)
      use hp_hbcorr, only: hbond_energy
      implicit none
      integer natoms, ncoefs, frag, kind, debug
      integer ilabels(natoms)
      character*2  atom(natoms)
      double precision geoxyz(3,natoms)
      double precision hb_energy
      double precision param_list(natoms)
      logical hbdebug
      
      if(debug.ge.1) then
        hbdebug=.true.
      else
        hbdebug=.false.
      endif
      
      call hbond_energy(natoms, geoxyz, ilabels, param_list, hb_energy, frag, kind, hbdebug)
      
      if(hbdebug) then
       print *,'hb_energy=',hb_energy
      end if
      
      hbwrapper=hb_energy

end function hbwrapper
      






