/*
(c) GAFit toolkit $Id: hbonds.h 562 2025-12-11 15:34:12Z ro $
*/

#ifndef _HBONDS_H_
#define _HBONDS_H_

#define BOHR2ANGSTROM  0.52917726
#define HARTREE2KCAL 627.509541
#define HB_BANNER "\nThis part cite as:\n\n"\
        "  Korth M.\n"\
        "  J. Chem. Theory Comput., 2010, 6 (12), pp 3808-3816\n"\
        "  DOI: 10.1021/ct100408b\n"\
        "\n"\
        "  Kromann J. C., Christensen A. S., Steinmann C., Korth M., Jensen J.H.\n"\
        "  PeerJ 2:e449 (2014)\n"\
        "  DOI: 10.7717/peerj.449\n"\
        "\n"
#define HbWrapper hbwrapper_
#define Printador printador_

#define HB_INTERACTION "Hydrogen Bonds"
#define PHB_INTERACTION "Hybrogen Bonds by pairs"

#define DEFAULT_HB_DEBUG 0
#define DEFAULT_PHB_DEBUG 0

#define HB_KIND_ALL 0
#define HB_KIND_INTRA 1
#define HB_KIND_INTER 2
#define HB_KIND_DEFAULT 2
#define LIST_HB_KINDS  {"all","intra","inter",NULL}
#define HB_ALGO_NONE 0
#define HB_ALGO_HB 1
#define HB_ALGO_PHB 2
#define LIST_HB_ALGO {"none","hb","phb",NULL}
#define HB_ALGO_DEFAULT 0


void analyzeHb (MULTIJOB * j);
void analyzePhb (MULTIJOB * j);
void printHBounds (MULTIJOB * j);
void printPHBounds (MULTIJOB * j);
char *getHbCoefString (int n, HBONDS * hbonds);
char **getHbCoefStringS (HBONDS * hbonds);
double HbWrapper (int *natoms, char *labels, int *ilabels,
		  double *atomcoefs, double *geoxyz, int *frag, int *kind,
		  int *debug);
char **getPhbCoefStringS (PHBONDS * phbonds);
int atomicNumber (char *atom);
#endif
