    

c register each potential with its own name, fortran function number,
c number of coeficients and type.      
       integer function fsetuppots()
       external registerpot
       call registerpot('exp1',1,4,'2') 
       call registerpot('exp2',2,6,'2')
       call registerpot('exp3',3,8,'2')
       call registerpot('fgc5',4,5,'2')
       call registerpot('fgc6',5,6,'2')
       call registerpot('fgc7',6,6,'2')
       end

c potential router, route calculations to the desired potential  
c (*@\label{multiPotRouter}@*)
c
c     fn = function number  
c    sys = system
c    geo = geometry
c     na = number of atoms. 2body=2, 3body=3
c  atoms = atoms array, dimension na
c     nr = number of distances. 2body=1, 3body=3
c      r = distance array, dimension nr
c     nc = number of coefficients
c     vc = coefficients vector, dimension nc


      function frouter(fn,system,geo,na,atoms,nr,r,nc,vc)
      external cstopit
      double precision frouter
      integer fn,system,geo,na,nr,nc
      integer atoms(na)
      double precision r(nr),vc(nc)

c declare here each function:
      double precision exp1,exp2,exp3,fgc5,fgc6,fgc7

      if (fn .eq. 1) then
        frouter=exp1(system,geo,na,atoms,nr,r,nc,vc)
      else if (fn .eq. 2)then
        frouter=exp2(system,geo,na,atoms,nr,r,nc,vc)
      else if (fn .eq. 3) then
        frouter=exp3(system,geo,na,atoms,nr,r,nc,vc)
      else if (fn .eq. 4) then
        frouter=fgc5(system,geo,na,atoms,nr,r,nc,vc)
      else if (fn .eq. 5) then
        frouter=fgc6(system,geo,na,atoms,nr,r,nc,vc)
      else if (fn .eq. 6) then
        frouter=fgc7(system,geo,na,atoms,nr,r,nc,vc)
      else
        call cstopit('fortran not implemented potential')
      endif

      end function frouter

c Now, each potential calculation down from here.
c Each one calculates **one interaction** contribution
c    sys = system
c    geo = geometry
c     na = number of atoms, 2body=2, 3body=3
c  atoms = atoms array, dimension na
c     nr = number of distances, 2body=1, 3body=3
c      r = distance array, dimension nr
c     nc = number of coefficients
c     vc = coefficients vector, dimension nc

c-----------------------exp1
      function exp1(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na) 
      double precision exp1,r(nr)
      double precision vc(nc)

      exp1 = vc(1)*exp(-vc(2)*r(1))+vc(3)/r(1)**vc(4)

      return
      end
 
c-----------------------exp2
      function  exp2(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na)
      double precision exp2,r(nr)
      double precision vc(nc)
                         
      exp2 = vc(1)*exp(-vc(2)*r(1))+vc(3)/r(1)**vc(4)+vc(5)/r(1)**vc(6)
      
      return 
      end

c-----------------------exp3
      function exp3(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na)
      double precision exp3,r(nr)
      double precision vc(nc)
                         
      exp3 = vc(1)*exp(-vc(2)*r(1))+vc(3)/r(1)**vc(4)+
     +      vc(5)/r(1)**vc(6)+vc(7)/r(1)**vc(8)

      return
      end

c-----define other functionss from here
c-----------------------fgc5
      function fgc5(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na)
      double precision fgc5,r(nr)
      double precision vc(nc)
      
      fgc5 = (0.5d0+0.5d0*tanh(10.0d0*(r(1)-vc(5))))*
     +       (vc(1)*exp(-vc(2)*r(1))+vc(3)/r(1)**vc(4))
c      fcut = 0.5d0+0.5d0*tanh(10.0d0*(r-vc(5)))
c      fgc5 = fcut*(vc(1)*exp(-vc(2)*r)+vc(3)/r**vc(4))

      return
      end

c-----define other functionss from here
c-----------------------fgc6  Damping from Head-Gordon's work
c----- Chai and Head-Gordon PCCP, 2008, 10, 6615-6620
      function fgc6(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na)
      double precision fgc6,r(nr)
      double precision vc(nc)

      fgc6 = (1.0d0/(1.0d0 + vc(6)*(vc(5)/r(1))**12))*
     +       (vc(1)*exp(-vc(2)*r(1))+vc(3)/r(1)**vc(4))

      return
      end

c-----------------------fgc7  Damping from Head-Gordon's work
c----- Chai and Head-Gordon PCCP, 2008, 10, 6615-6620
      function fgc7(system,geo,na,atoms,nr,r,nc,vc)
      integer system,geo,na,nr,nc
      integer atoms(na)
      double precision fgc7,r(nr),damp
      double precision vc(nc)

      damp = 1.0d0/(1.0d0 + vc(6)*(vc(5)/r(1))**12)
      fgc7 = vc(1)*exp(-vc(2)*r(1)) + damp*vc(3)/r(1)**vc(4)
      return
      end






