/*
(c) GAFit toolkit $Id: common.c 561 2025-12-10 15:24:48Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../core.h"
#include "../environ/environ.h"
#include "../rstrings/rstrings.h"
#include "../flyctl/flyctl.h"
#include "../inputline/line.h"
#include "../job.h"
#include "multijob.h"
#include "multi.h"

char *ToolsOutput = NULL;


void
printSepBar (FILE * f)
{
  fprintf (f, "--------------------------------\n");
}

void
InitEnvironmentVariables (JOB * job)
{
  job->external_input = SetEnv ("EXTERNAL_INPUT", EXTERNAL_INPUT);
  job->external_fit = SetEnv ("EXTERNAL_FIT", EXTERNAL_FIT);
  job->external_bounds = SetEnv ("BOUNDS_FILE", BOUNDS_FILE);
  ToolsOutput = sLowerCase (SetEnv ("TOOLS_OUTPUT", TOOLS_OUTPUT));
}

//autoconfigure
void
WriteResponse (MULTIJOB * j)
{
  FILE *r;
  char *nwbounds;
  nwbounds = MakePath (j->job->external_bounds, ".internal");
  r = fopen ("response", "w");
  if (!r)
    {
      printf ("Cannot open file 'response'\n");
      fcStopIt ("error intpot 'response'\n");
    }
  fprintf (r, "\n");
  fprintf (r, "[job]\n");
  fprintf (r, "type: external bulk\n");
  fprintf (r, "coefficients: %d\n", NC (j));	//2body + 3body + hb ints.
  fprintf (r, "external input: %s\n", j->job->external_input);
  fprintf (r, "external fit: %s\n", j->job->external_fit);
  fprintf (r, "bounds: %s\n", nwbounds);
  fprintf (r, "final evaluation: yes\n");
  fprintf (r, "\n");
  fclose (r);
  free (nwbounds);
  return;
}

void
ReadInputVector (int indv, MULTIJOB * j, p_ind population)
{
  int k, i, r;
  int count;
  char *s;
  FILE *f;
  int t3 = 0;
  int t2 = 0;
  int th = 0;

  t2 = j->job->N;
  t3 = j->job->N;
  th = j->job->N;

  if (j->tbinteractions)
    {
      t3 += j->tbody->N;
      th += j->tbody->N;
    }
  if (j->hbinteractions)
    {
      th += j->hbonds->N;
    }
  f = fopen (j->job->external_input, "r");
  if (j->debug)
    {
      printf ("Reading %s file\n", j->job->external_input);
      printf ("individuals: %d, coefficients per individual 2body: %d", indv,
	      j->job->N);
      if (j->tbinteractions)
	{
	  printf (" 3body: %d", j->tbody->N);
	}
      if (j->hbinteractions)
	{
	  printf (" hb: %d", j->hbonds->N);
	}
      printf (" total: %d", NC (j));
      printf ("\n");
    }
  if (f)
    {
      for (k = 0; k < indv; k++)
	{
	  if (j->debug)
	    {
	      printf ("\tindividual:%d\n\t\t", k);
	      count = 0;
	      printf ("[interaction %d]", count++);
	    }

	  for (i = 0; i < NC (j); i++)
	    {
	      s = InputFileLine (f);
	      if (!s)
		{
		  printf ("Error!\n");
		  fcStopIt ("No input in file jo->external_input\n");
		}
	      r = sscanf (s, "%lf", &population[k].genes[i]);
	      if (r == 0)
		fcStopIt ("Error reading External Input\n");
	      free (s);

	      if (j->debug)
		{
		  if (j->tbinteractions)
		    {
		      if (i == t2)
			{
			  printf ("\n\t------ 3body -------\n\t\t");
			  count = 0;
			  printf ("\n\t\t[interaction %d]", count++);
			}
		    }
		  if (j->hbinteractions)
		    {
		      if (i == t3)
			{
			  printf ("\n\t------ Hb -----------\n\t\t");
			  count = 0;
			  printf ("\n\t\t[interaction %d]", count++);
			}
		    }

		  printf ("[coefficient %d] -> %f ", i,
			  population[k].genes[i]);

		  if (i < t2)
		    {
		      if (((i + 1) % j->job->ncoefs) == 0
			  && count != j->count2body)
			printf ("\n\t\t[interaction %d]", count++);
		    }
		  if (j->tbinteractions)
		    {
		      if (i >= t2 && i < t3)
			{
			  if (((i + 1) % j->tbody->ncoefs) == 0
			      && count != j->tbody->count3body)
			    printf ("\n\t\t[interaction %d]", count++);
			}
		    }
		  if (j->hbinteractions)
		    {
		      if (i >= t3 && i < th)
			{
			  if (((i + 1) % j->hbonds->ncoefs) == 0
			      && count != j->hbonds->countHb)
			    printf ("\n\t\t[interaction %d]", count++);
			}
		    }
		}
	    }

	  if (j->debug)
	    printf ("\n");
	  s = InputFileLine (f);
	  free (s);
	}
      fclose (f);
    }
  else
    {
      printf ("No file %s\n", j->job->external_input);
      fcStopIt ("No file jo->external_input\n");
    }
}

void
WriteFit (int indv, MULTIJOB * j, p_ind pop)
{
  FILE *f = fopen (j->job->external_fit, "w");
  if (f)
    {
      for (int i = 0; i < indv; i++)
	{
	  fprintf (f, "%lf\n", pop[i].fitness);
	}
      fclose (f);
    }
  else
    fcStopIt ("cannot write external.fit");
}

void
RunEvaluation (int indv, MULTIJOB * j)
{
  p_ind population = malloc (sizeof (ind) * indv);	//indv=jo->pop_size if bulk
  for (int i = 0; i < indv; i++)
    population[i].genes = malloc (sizeof (double) * NC (j));	//coefs=jo->N

  ReadInputVector (indv, j, population);

  for (int i = 0; i < indv; i++)
    {
      if (j->debug)
	{
	  printf ("\n====Iindividual %d\n", i);
	}
      population[i].fitness = eval_multi (j, population[i].genes);
    }

  WriteFit (indv, j, population);

  for (int i = 0; i < indv; i++)
    free (population[i].genes);
  free (population);
}
