/*
  (c)GAFit toolkit $Id: bounds.c 561 2025-12-10 15:24:48Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../inputline/line.h"
#include "../core.h"
#include "../numbers.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../cnames.h"
#include "../flyctl/flyctl.h"
#include "../job.h"
#include "multijob.h"
#include "auxfuncs.h"
#include "bounds.h"


void
ReadBounds (domain * v, const char *file, int coefs, int inter)
{
  char *s;
  FILE *f;
  int n = 0;
  int r, l;
  int lines;
  int coefsBlock = coefs + 1;	//plus text line per each coefs set.

  lines = coefsBlock * inter;
  //printf ("File:%s, coefs/inter:%d, interactions:%d\n", file, coefs, inter);
  f = fopen (file, "r");
  if (f)
    {
      l = 0;
      while ((s = InputFileLine (f)) != NULL)
	{
	  l++;
	  if (l - 1 > lines)
	    break;
	  if ((n) % coefsBlock)
	    {
	      r = sscanf (s, "%lf %lf %d", &v->min, &v->max, &v->decimals);
	      if (r < 3)
		{
		  printf ("Bounds - Error reading line %d, text:'%s'.\n", l,
			  s);
		  printf ("         Expected min max decimals\n");
		  exit (EXIT_FAILURE);
		}
	      v->gap = v->max - v->min;
	      v++;
	    }
	  free (s);
	  n++;
	}
      free (s);
      fclose (f);
    }
  else
    {
      fcPrintfStopIt ("Bounds - File not found: %s\n", file);
    }
  if (lines > l)
    {
      fcPrintfStopIt
	("Bounds - Error, short read, expected %d, found %d lines.\n", lines,
	 l);
    }
}

void
PrintCoefNames (vect_domain bounds, int ncoefs, int i, int j, int shift)
{
  int total = ncoefs + shift;
//  char *clet = Letters (((j * total + i) % total)+shift );
//printf("%s_---",clet);
  printf ("\t%5d %10s %20.17g - %20.17g (%s)\n",
	  j * ncoefs + i + 1,
	  CoefName (((j * total + i) % total + shift)),
	  bounds[j * ncoefs + i].min, bounds[j * ncoefs + i].max,
	  ii (bounds[j * ncoefs + i].decimals));
  //free (clet);
}


void
PrintBounds (MULTIJOB * jo, vect_domain bounds, int ninter, int ncoefs,
	     int first, int last, char kind)
{
  int shift;
  setMPointer (jo);
//  printf ("pb: ninter:%d, ncoefs:%d, first:%d, last:%d, kind:%c\n", ninter,
//        ncoefs, first, last, kind);

  switch (kind)
    {
    case '2':
      shift = 0;
      break;
    case '3':
      shift = jo->job->ncoefs;
      break;
    case 'H':
      shift = jo->job->ncoefs + jo->tbody->ncoefs;
      break;
    }

  if (first < 1)
    first = 1;
  if (last > ninter)
    last = ninter;

  for (int j = first - 1; j < last; j++)
    {
      for (int i = 0; i < ncoefs; i++)
	{
	  if ((j * ncoefs + i) % ncoefs == 0)
	    {
	      printf ("INTERACTION TYPE %d ( %s )\n", j + 1,
		      strInterTypeAll (j + 1, kind));
	      printf ("----------------------------\n");
	      printf ("\tCoefficients:\n");
	    }
	  PrintCoefNames (bounds, ncoefs, i, j, shift);
	}
      printf ("\n");
    }
}
