/*
(c) GAFit toolkit $Id: 3body.c 561 2025-12-10 15:24:48Z ro $
*/

#define _GNU_SOURCE
#include <stdio.h>
#include "../job.h"
#include "multijob.h"
#include "multi.h"
#include "3body.h"

// reorder indexes, lower first and so on.
void
cubeOrder (int *a, int *b, int *c)
{
  int swp;
  // reorder index, lower first and so on.
  while (!(*a <= *b && *b <= *c))
    {
      if (*a > *b)
	{
	  swp = *b;
	  *b = *a;
	  *a = swp;
	}
      if (*b > *c)
	{
	  swp = *c;
	  *c = *b;
	  *b = swp;
	}
    }
}

void
tbAnotate (int len, int cube[len][len][len], int a, int b, int c)
{
  cubeOrder (&a, &b, &c);
  cube[a][b][c]++;
}

void
printCube (int len, int cube[len][len][len])
{
  for (int i = 0; i < len; ++i)
    {
      for (int k = 0; k < len; ++k)
	{
	  for (int l = 0; l < len; ++l)
	    {
	      if (cube[i][k][l] != 0)
		printf ("%d-%d-%d -> %d ", i, k, l, cube[i][k][l]);
	    }
	  printf ("\n");
	}
      printf ("\n");
    }
  printf ("\n");
}

void
print3Body (MULTIJOB * j)
{
  int x, y;
  x = y = 0;
  printf ("\n");
  printf ("3BODY INTERACTIONS\n");
  printSepBar (stdout);

  printf ("\n");
  printf ("3body distinct interactctions count: %d.\n", j->tbody->count3body);
  printf
    ("3body potential read: %s. This potential has %d coefficients per interaction.\n",
     j->tbody->potential_name, j->tbody->ncoefs);
  printf ("Read all coefficients: %s, %s\n", j->tbody->rcoefs ? "yes" : "no",
	  ReadCoefs (j->tbody->rcoefs));

  printf ("\n");
  printf ("3BODY INTERACTIONS LIST\n");
  printSepBar (stdout);

  for (int i = 0; i < j->tbody->count3body; i++)
    {
      if (j->tbody->tbodyint[i].typea != x
	  || j->tbody->tbodyint[i].typeb != y)
	{
	  printf ("\n");
	  x = j->tbody->tbodyint[i].typea;
	  y = j->tbody->tbodyint[i].typeb;
	}
      printf ("%5d %-11s ", i + 1, j->tbody->tbodyint[i].str);
    }

}

int
countCube (int len, int cube[len][len][len])
{
  int counter = 0;
  for (int i = 0; i < len; ++i)
    {
      for (int k = 0; k < len; ++k)
	{
	  for (int l = 0; l < len; ++l)
	    {
	      if (cube[i][k][l] != 0)
		counter++;
	    }
	}
    }
  return counter;
}


void
analyze3body (MULTIJOB * j)
{
  int cube[j->dtypes][j->dtypes][j->dtypes];
  int a, b, c;

  for (int i = 0; i < j->dtypes; ++i)
    for (int k = 0; k < j->dtypes; ++k)
      for (int l = 0; l < j->dtypes; ++l)
	cube[i][k][l] = 0;

  // a-b-b
  for (int i = 0; i < j->nsys; i++)
    {
      for (int k = 0; k < j->data[i]->ntypea; k++)
	{
	  a = type2num (j->data[i]->dtypea[k], j);
	  for (int l = 0; l < j->data[i]->ntypeb; l++)
	    {
	      b = type2num (j->data[i]->dtypeb[l], j);
	      //for (int m = l + 1; m < j->data[i]->ntypeb; m++)
	      for (int m = l; m < j->data[i]->ntypeb; m++)
		{
		  c = type2num (j->data[i]->dtypeb[m], j);
		  tbAnotate (j->dtypes, cube, a, b, c);
		}
	    }
	}
    }

  // b-a-a
  for (int i = 0; i < j->nsys; i++)
    {
      for (int k = 0; k < j->data[i]->ntypeb; k++)
	{
	  a = type2num (j->data[i]->dtypeb[k], j);
	  for (int l = 0; l < j->data[i]->ntypea; l++)
	    {
	      b = type2num (j->data[i]->dtypea[l], j);
	      //for (int m = l + 1; m < j->data[i]->ntypea; m++)
	      for (int m = l; m < j->data[i]->ntypea; m++)
		{
		  c = type2num (j->data[i]->dtypea[m], j);
		  tbAnotate (j->dtypes, cube, a, b, c);
		}
	    }
	}
    }


  // printCube (j->dtypes, cube);
  //
  // list of total distinct 3body interactions
  // 
  j->tbody->count3body = countCube (j->dtypes, cube);

  TBODYINT *tbint = malloc (sizeof (TBODYINT) * j->tbody->count3body);
  int index = 0;

  for (int i = 0; i < j->dtypes; ++i)
    for (int k = 0; k < j->dtypes; ++k)
      for (int l = 0; l < j->dtypes; ++l)
	{
	  if (cube[i][k][l] != 0)
	    {
	      tbint[index].typea = i;
	      tbint[index].typeb = k;
	      tbint[index].typec = l;
	      asprintf (&tbint[index].str, "%s-%s-%s", j->types[i],
			j->types[k], j->types[l]);
	      index++;
	    }
	}
  j->tbody->tbodyint = tbint;
  ///
  /// atom-atom-atom-3body interaction number MATRIX.
  ///
  ///    print3Body (j);

}
