c accessing fitting data
c  vvvvvvv  WARNNING  vvvvvvv  WARNNING  vvvvvvv
c  hiddencounter: individual index, managed by the fitter
c  ^^^^^^^  WARNNING  ^^^^^^^  WARNING   ^^^^^^
c  calculus: number of calculus in the template.mop
c  hasdata: for each individual if all the template.mop 
c           calculus are ok
c  fheatfcal: heat of formation, kcal/mol
c  fheatfjul: heat of formation, kjul/mol
c  numatoms: integer, number of atoms
c  atom: character*2, symbol.
c  xyz: cartesian coordinates
c  freqs: frecuencies in ascending order
c  lastfreq: the last one 
c  numfreq: integer, number of frecuencies
c  distance: distance between two atoms
c  gradient: atomic cartesian component
c **************************************************
      double precision function heatfcal(calculus)
      use fitterdata
      implicit none
      integer calculus
      if(.not. hasdata(hiddencounter)) stop 'error: no data heatfcal'
      heatfcal=fheatfcal(hiddencounter,calculus)
      return
      end
     
      double precision function heatfjul(calculus)
      use fitterdata
      implicit none
      integer calculus
      if(.not. hasdata(hiddencounter)) stop 'error: no data heatfjul'
      heatfjul=fheatfjul(hiddencounter,calculus)
      return
      end

      double precision function deltahc(calc1,calc2)
      use fitterdata
      implicit none
      integer calc1,calc2
      double precision heatfcal
      if (.not. hasdata(hiddencounter)) stop 'error: no data deltahc'
      deltahc=heatfcal(calc1)-heatfcal(calc2)
      return
      end
           
      double precision function distance(calculus, atom1,atom2)
      use fitterdata
      implicit none
      integer calculus, atom1, atom2,i
      if(.not. hasdata(hiddencounter)) stop 'error: no data distance'
      distance=0
      do i=1,3
      distance=distance+(xyz(hiddencounter,calculus,atom1,i )
     + -xyz(hiddencounter,calculus,atom2,i))**2
      enddo
      distance=sqrt(distance)
      return
      end
      
      double precision function freq(calculus,number)
      use fitterdata
      implicit none
      integer calculus, number
      if(.not. hasdata(hiddencounter)) stop 'error: no data freq'
      freq=freqs(hiddencounter,calculus,number)
      return
      end

      double precision function grad(calculus,number)
      use fitterdata
      implicit none
      integer calculus, number
      if(.not. hasdata(hiddencounter)) stop 'error: no data grads'
      grad=grads(hiddencounter,calculus,number)
      return
      end

c angle between atom1-atom2-atom3 
      double precision function angle(calculus,atom1,atom2,atom3)
      use fitterdata
      integer calculus,atom1,atom2,atom3,i
      double precision a(3),b(3),c(3)
      double precision dotp,mod1,mod2
      if(.not. hasdata(hiddencounter)) stop 'error: no data freq'
      dotp=0
      mod1=0
      mod2=0
      do i=1,3
c read data, dot product and modulus     
        a(i)=xyz(hiddencounter,calculus,atom1,i)
        b(i)=xyz(hiddencounter,calculus,atom2,i)
        c(i)=xyz(hiddencounter,calculus,atom3,i)
        dotp=dotp+(a(i)-b(i))*(c(i)-b(i))
        mod1=mod1+(a(i)-b(i))**2
        mod2=mod2+(c(i)-b(i))**2
      enddo
c modulus
      mod1=sqrt(mod1)
      mod2=sqrt(mod2)
      angle=acos(dotp/(mod1*mod2))*180/3.14159265
      return
      end      

c dihedral angle between atom1-atom2-atom3-atom4 
      function dihedral(calculus,atom1,atom2,atom3,atom4)
      use fitterdata
      double precision dihedral
      integer calculus,atom1,atom2,atom3,atom4,i
          
      double precision a(3),b(3),c(3),d(3)
      double precision v1(3),v2(3),v3(3)
      double precision w1(3),w2(3),ww(3)
      double precision u1(3),u2(3),su(3)
      double precision w1mod,w2mod,wdot
      double precision cosa,umod

      double precision vdot,vmod
      
      if(.not. hasdata(hiddencounter)) stop 'error: no data freq'
c vectors      
      do i=1,3
      a(i)=xyz(hiddencounter,calculus,atom1,i)
      b(i)=xyz(hiddencounter,calculus,atom2,i)
      c(i)=xyz(hiddencounter,calculus,atom3,i)
      d(i)=xyz(hiddencounter,calculus,atom4,i)
      enddo
      
      call vector(a,b,v1)
      call vector(b,c,v2)
      call vector(c,d,v3)
      
      call vcross(v1,v2,w1)
      call vcross(v2,v3,w2)
      
      call vcross(w1,w2,ww)

      wdot=vdot(w1,w2)
      
      w1mod=vmod(w1)
      w2mod=vmod(w2)
            
      cosa=wdot/(w1mod*w2mod)
      dihedral=acos(cosa)*180/3.1415926  

      call uvector(ww,u1)
      call uvector(v2,u2)

      call svector(u1,u2,su)

      umod=vmod(su)
c check sign
      if(umod.gt.1) then
      	dihedral=-dihedral
      endif
      end

      double precision function dipx(calculus,state)
      use fitterdata
      integer calculus,state
      if(.not.hasdata(hiddencounter)) stop 'error; no data dip'
      dipx=dipxyz(hiddencounter,calculus,state,1)
      return
      end
     
      double precision function dipy(calculus,state)
      use fitterdata
      integer calculus,state
      if(.not.hasdata(hiddencounter)) stop 'error; no data dip'
      dipy=dipxyz(hiddencounter,calculus,state,2)
      return
      end

      double precision function dipz(calculus,state)
      use fitterdata
      integer calculus,state
      if(.not.hasdata(hiddencounter)) stop 'error; no data dip'
      dipz=dipxyz(hiddencounter,calculus,state,3)
      return
      end

      double precision function eel(calculus,state,order)
      use fitterdata
      integer calculus, state,order
      if(.not.hasdata(hiddencounter)) stop 'error: no data eel'
      eel=states(hiddencounter,calculus,state,order)
      return
      end

      logical function haseel(calculus,state,order)
      use fitterdata
      integer calculus,state,order
      haseel=hasstates(hiddencounter,calculus,state,order)
      return
      end

c helper subroutines to calculate angles
      subroutine svector(a,b,v)
      double precision a(3),b(3),v(3)
      integer i
      do i=1,3
      v(i)=a(i)+b(i)
      enddo
      end
      
      subroutine uvector(a,v)
      double precision vmod
      double precision a(3),v(3)
      double precision vvmod
      integer i
      vvmod=vmod(a)
      do i=1,3
      v(i)=a(i)/vvmod
      enddo
      end
            
      subroutine vcross(a,b,v)
      double precision a(3),b(3),v(3)
      v(1)=a(2)*b(3)-b(2)*a(3)
      v(2)=a(1)*b(3)-b(1)*a(3)
      v(3)=a(1)*b(2)-b(1)*a(2)
      end
      
      subroutine vector(a,b,v)
      double precision a(3),b(3),v(3)
      integer i
      do i=1,3
      v(i)=b(i)-a(i)
      enddo
      end
      
      subroutine vmult(a,v,k)
      double precision a(3),v(3),k
      integer i
      do i=1,3
      v(i)=k*a(i)
      enddo
      end
      
      function vmod(a)
      double precision vmod
      double precision a(3)
      integer i
      vmod=0
      do i=1,3
      vmod=vmod+a(i)*a(i)
      enddo
      vmod=sqrt(vmod)
      end
      
      function vdot(a,b)
      double precision vdot
      double precision a(3),b(3)
      integer i
      vdot=0
      do i=1,3
      vdot=vdot+a(i)*b(i)
      enddo
      end      
c ----------------------------------------------      
      SUBROUTINE fittype (icmd, datatype)
      INTEGER icmd
      CHARACTER*(*) datatype
      IF (icmd.eq.1) datatype='HEAT'
      IF (icmd.eq.2) datatype='FREQUENCY'
      IF (icmd.eq.3) datatype='DISTANCE'
      IF (icmd.eq.4) datatype='ANGLE'
      IF (icmd.eq.5) datatype='DIHEDRAL'
      IF (icmd.eq.6) datatype='DELTA'
      IF (icmd.eq.7) datatype='GRADIENT'
      IF (icmd.eq.8) datatype='DIPX'
      IF (icmd.eq.9) datatype='DIPY'
      IF (icmd.eq.10) datatype='DIPZ'
      IF (icmd.eq.11) datatype='EEL'
      RETURN
      END
                                                                        

c *****************************************************
c  fitting function
c *****************************************************
      double precision function userfit()
      use fitterdata
      use conddata
      implicit none
      double precision heatfcal,freq,grad
      double precision distance,angle,dihedral
      double precision dipx,dipy,dipz,eel
      logical haseel
      double precision value,contrib
      integer i
      CHARACTER*15 ctype
      
      userfit=0
      
      if(.not. hasdata(hiddencounter)) then
       userfit=penalty
       if(toolsoutput) then
         print *,'PENALTY',' cont=',penalty
       endif
       return
      endif
      
      do i=1,conditions
        if (icmd(i).eq.1) then
          value=heatfcal(icalc(i))
        else if (icmd(i).eq.2) then
          value=freq(icalc(i),aint1(i))
        else if (icmd(i).eq.3) then
          value=distance(icalc(i),aint1(i),aint2(i))
        else if (icmd(i).eq.4) then
          value=angle(icalc(i),aint1(i),aint2(i),aint3(i))
        else if (icmd(i).eq.5) then
          value=dihedral(icalc(i),aint1(i),aint2(i),aint3(i),aint4(i))
        else if (icmd(i).eq.6) then
          value=heatfcal(icalc(i))-heatfcal(aint1(i))
        else if (icmd(i).eq.7) then
          value=grad(icalc(i),aint1(i))
        else if (icmd(i).eq.8) then
          value=dipx(icalc(i),aint1(i))
        else if (icmd(i).eq.9) then
          value=dipy(icalc(i),aint1(i))
        else if (icmd(i).eq.10) then
          value=dipz(icalc(i),aint1(i))
        else if (icmd(i).eq.11) then
          if(haseel(icalc(i),aint1(i),aint2(i))) then
           value=eel(icalc(i),aint1(i),aint2(i))
          else
            userfit=penalty
            if(toolsoutput) then
              print *,'no eel state: PENALTY',' cont=',penalty
            endif
            return
          endif
        else
          print *,'error conditions'
          stop
        endif
        contrib=(dvalue(i)-value)**2*dw(i)
        userfit=userfit+contrib
        call fittype (icmd(i), ctype)
        if(toolsoutput)then
        print *,ctype,' calc=',value,
     +  ' ref=',dvalue(i),' we=',dw(i),' cont=',contrib
        endif
      enddo
      end

