/*
(c) GAFit toolkit $Id: mopac.h 321 2018-03-20 15:34:35Z ro $
*/

#ifndef _MOPAC_INTERFACE_
#define _MOPAC_INTERFACE_
#define COEFS_TEMPLATE "template.coefs"
#define MOPAC_TEMPLATE "template.mop"
#define MOPAC_MOP      "mopac_input.mop"
#define EXTERNAL_INPUT "mopac.input"
#define EXTERNAL_FIT   "mopac.fit"
#define BOUNDS_FILE    "bounds.txt"
#define MOPAC_LICENSE  "/opt/mopac"
#define MOPAC_EXECUTABLE "MOPAC2009.exe"
#define EXTERNAL_TYPE_NORMAL "external"
#define EXTERNAL_TYPE_BULK "external bulk"
#define EXTRACTED_DATA "extracted.data"
#define SHEPHERD_CORES  "0"

//there is no environment variable for this setting
#define CONDITIONS_FIT "conditions.txt"

#define SNPRINTF 200
#define SHEEP_MARK "Sheep #@#"
#define FLOCK_MAX 16
#define FILE_FTIMES "flockt.dat"
#define MEDIA_WINDOW 3
#define NON_RECOVERABLE_ERROR "SHEPHERD NON RECOVERABLE ERROR"
#define MOPAC_SITE " ** Site#:"
#define MOPAC_DONE " == MOPAC DONE =="

//null terminated list of mopac temporary extensions 
#define MOPAC_F_LIST {".arc",".den",".res",NULL}

//output options
#define TOOLS_OUTPUT "no"

#define getFileFit getfilefit_
#define  getFileData getfiledata_
#define getFileCond getfilecond_


typedef struct savetime SATIME;

struct savetime
{
  double t;
  int n;
  double min;
  double max;
};

char *SetEnv (char *s, char *ss);

void InitEnvironmentVariables (void);

void
CreateMopacMop (int findv, int lindv, char *fileMopacTemplate,
		char *fileMopacMop);
void CreateExternals (int indv, int n, char *fileExternalInput);
int CountCalcs (char *fileMopacTemplate);
int CountCoefficients (void);
#endif
