/*
(c) GAFit toolkit $Id: mopac.c 321 2018-03-20 15:34:35Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../inputline/line.h"
#include "../nullist/nllist.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../flyctl/flyctl.h"
#include "../environ/environ.h"

#include "mopac.h"

char *CoefsTemplate = NULL;
char *MopacTemplate = NULL;
char *MopacMop = NULL;
char *ExternalInput = NULL;
char *ExternalFit = NULL;
char *Bounds = NULL;
char *MopacLicense = NULL;
char *MopacExecutable = NULL;
int NCores = 0;
int ToolsOutput = 0;

char **names = NULL;
char **atoms = NULL;
double *coefs = NULL;

void
InitEnvironmentVariables (void)
{
  char *text;
  CoefsTemplate = SetEnv ("COEFS_TEMPLATE", COEFS_TEMPLATE);
  MopacTemplate = SetEnv ("MOPAC_TEMPLATE", MOPAC_TEMPLATE);
  MopacMop = SetEnv ("MOPAC_MOP", MOPAC_MOP);
  ExternalInput = SetEnv ("EXTERNAL_INPUT", EXTERNAL_INPUT);
  ExternalFit = SetEnv ("EXTERNAL_FIT", EXTERNAL_FIT);
  Bounds = SetEnv ("BOUNDS_FILE", BOUNDS_FILE);
  MopacLicense = SetEnv ("MOPAC_LICENSE", MOPAC_LICENSE);
  MopacExecutable = SetEnv ("MOPAC_EXECUTABLE", MOPAC_EXECUTABLE);
  text = sLowerCase (SetEnv ("TOOLS_OUTPUT", TOOLS_OUTPUT));
  NCores = atoi (SetEnv ("SHEPHERD_CORES", SHEPHERD_CORES));
  if (strcmp (text, "yes") == 0)
    ToolsOutput = 1;
}


char *
addHerd (char *s)
{
  char *p;
  char *r;
  char mark[] = SHEEP_MARK;
  int n = strlen (s);
  r = (char *) malloc (sizeof (char) * (strlen (mark) + n + 1));
  if (!r)
    fcStopIt ("mopac.c addHerd: no memory");
  strcpy (r, s);
  p = strstr (r, "\n");
  if (!p)
    {
      free (r);
      return s;
    }
  p++;
  strcpy (p, mark);
  p = strstr (s, "\n") + 1;
  strcat (r, p);
  free (s);
  return r;
}

void
CreateMopacMop (int findv, int lindv, char *fileMopacTemplate,
		char *fileMopacMop)
{
  FILE *e, *h;
  char *moptext, *mopcpy;
  int j;

  h = fopen (fileMopacTemplate, "r");
  if (h)
    {
      moptext = InputFileText (h);
      fclose (h);
      moptext = sSLtrim (moptext);
      moptext = sSRtrim (moptext);
      moptext = addHerd (moptext);
      e = fopen (fileMopacMop, "w");
      if (e)
	{
	  for (j = findv; j < lindv; j++)
	    {
	      char *tmp = Letters (j);
	      mopcpy = strdup (moptext);
	      mopcpy = sReplaceString (mopcpy, "@", tmp);
	      fprintf (e, "%s\n\n", mopcpy);
	      free (mopcpy);
	      free (tmp);
	    }
	  fclose (e);
	}
      else
	{
	  printf ("Cannot create file %s\n", fileMopacMop);
	  fcStopIt ("mopac.c Cannot create MopacMop\n");
	}
    }
  else
    {
      printf ("No file %s\n", fileMopacTemplate);
      fcStopIt ("mopac.c No file MopacTemplate\n");
    }
}


void
CreateExternals (int indv, int n, char *fileExternalInput)
{
  int j, i, r;
  char *s;
  FILE *f, *g;
  f = fopen (fileExternalInput, "r");
  if (f)
    {

      for (j = 0; j < indv; j++)
	{
	  char *tmp = Letters (j);
	  g = fopen (tmp, "w");
	  if (!g)
	    {
	      printf ("Cannot create file %s\n", Letters (j));
	      fcStopIt ("mopac.c Cannot create exernal mopac file\n");
	    }
	  for (i = 0; i < n; i++)
	    {
	      s = InputFileLine (f);
	      if (!s)
		{
		  printf ("Error!\n");
		  fcStopIt ("mopac.c No input in file ExternalInput\n");
		}
	      r = sscanf (s, "%lf", &coefs[i]);
	      if (r == 0)
		fcStopIt ("mopac.c Error reading External Input\n");
	      fprintf (g, "%s  %s  %lf\n",
		       nllString (names, i), nllString (atoms, i), coefs[i]);
	      free (s);
	    }
	  fprintf (g, "END\n");
	  free (tmp);
	  fclose (g);
	  s = InputFileLine (f);
	  free (s);
	}
      fclose (f);
    }
  else
    {
      printf ("No file %s\n", fileExternalInput);
      fcStopIt ("mopac.c No file ExternalInput\n");
    }
  nllClear (names);
  nllClear (atoms);
  free (coefs);
}

int
CountCalcs (char *fileMopacTemplate)
{
  FILE *h;
  char *s, *p;
  int n = 0;
  h = fopen (fileMopacTemplate, "r");
  s = InputFileText (h);
  fclose (h);
  p = s;
  while ((p = strstr (p, "@")) != NULL)
    {
      n++;
      p++;
    }
  free (s);
  return n;
}

//counts coefficients and loads them
int
CountCoefficients (void)
{
  FILE *f;
  char *s;
  int l, r;
  char a[100], b[100];
  double c;

  f = fopen (CoefsTemplate, "r");
  if (f)
    {
      l = 0;
      while ((s = InputFileLine (f)) != NULL)
	{
	  l++;
	  r = sscanf (s, "%s %s %lf", a, b, &c);
	  if (r < 3 && r != EOF)
	    {
	      printf ("Template -  Error reading line %d, text:'%s'.\n", l,
		      s);
	      fcStopIt ("injector mopacCoefficientsCount\n");
	    }
	  if (r == EOF)
	    {
	      l--;
	      break;
	    }
	  else
	    {
	      names = nllAdd (names, strdup (a));
	      atoms = nllAdd (atoms, strdup (b));
	      coefs = (double *) realloc (coefs, sizeof (double) * l);
	      coefs[l - 1] = c;
	    }
	  free (s);
	}
      free (s);
      fclose (f);
      return l;
    }
  else
    {
      printf ("No file: %s\n", CoefsTemplate);
      fcStopIt ("injector mopacCoefficiensCount\n");
    }
  return 0;
}
