/*
$Id: mkbounds.c 318 2018-01-26 15:17:54Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <math.h>

#include "../inputline/line.h"
#include "../nullist/nllist.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../numbers.h"
#include "mopac.h"

extern char *CoefsTemplate;
extern char *ExternalInput;
extern char *ExternalFit;
extern char *Bounds;
extern char *MopacTemplate;
extern char *MopacMop;
extern char **names;
extern char **atoms;
extern double *coefs;

char *ExternalType = NULL;


void
writeBounds (int ncoefs, double var)
{
  FILE *r;
  int i;
  r = fopen (Bounds, "w");
  if (!r)
    {
      printf ("Cannot open file %s\n", Bounds);
    }
  fprintf (r, "mkbounds: %5.2f percent variation of %s\n", var,
	   CoefsTemplate);
  var = var / 100;

  for (i = 0; i < ncoefs; i++)
    fprintf (r, "%13.6f  %13.6f  %d\n", coefs[i] - fabs (coefs[i] * var),
	     coefs[i] + fabs (coefs[i] * var), DECIMAL_DOUBLE);
  fclose (r);
  return;
}

int
main (int argc, char **argv)
{
  int n;
  double var;

  if (argc != 2)
    {
      printf ("\nmkbounds v0.1 (c)GAFit toolkit - 2014\n");
      printf ("\tCreate bounds file form %s\n", CoefsTemplate);
      printf ("\tUsage: %s %%percent\n\n", argv[0]);
      exit (EXIT_SUCCESS);
    }
  var = atof (argv[1]);
  InitEnvironmentVariables ();
  n = CountCoefficients ();
  writeBounds (n, var);
}
