/*
(c) GAFit toolkit $Id: lstimes.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>

#include "mopac.h"
#include "../inputline/line.h"




void
lsReadFlockTimes (SATIME * flckt, int *lastn)
{
  FILE *ft;
  ft = fopen (FILE_FTIMES, "r");
  fread (lastn, sizeof (int), 1, ft);
  fread (flckt, sizeof (SATIME), FLOCK_MAX, ft);
  fclose (ft);
}

void
lsLoadFlockTimes (SATIME * flckt, int *lastn)
{
  int i;
  double tmin, aveg;
  int nmin, total;
  if (FileExist (FILE_FTIMES))
    {
      lsReadFlockTimes (flckt, lastn);
      aveg = 0;
      tmin = flckt[0].t;
      nmin = 0;
      total = 0;
      for (i = 1; i < FLOCK_MAX; i++)
	{
	  if (flckt[i].t < tmin && flckt[i].t != 0)
	    {
	      nmin = i;
	      tmin = flckt[i].t;
	    }
	  else
	    break;
	}
      printf (" -- ---- ----------- ----- ----------- -----------\n");
      printf (" PR slot current t     n      min        max\n");
      printf (" -- ---- ----------- ----- ----------- -----------\n");
      for (i = 0; i < FLOCK_MAX; i++)
	{
	  printf (" %c%c %4d %11.6f %5d %11.6f %11.6f\n",
		  nmin == i ? '*' : '-', *lastn - 1 == i ? '>' : '-', i + 1,
		  flckt[i].t, flckt[i].n, flckt[i].min, flckt[i].max);
	  total += flckt[i].n;
	  aveg += flckt[i].n * (i + 1);
	}
      aveg /= total;
      printf (" -------------------------------------------------\n");
      printf (" last:%d total:%d average:%5.2f\n", *lastn, total, aveg);

    }
}


int
main (void)
{
  SATIME flock_time[FLOCK_MAX];
  int lastn;
  while (1)
    {
      printf (" (c)GAFit toolkit 2014\n");
      lsLoadFlockTimes (flock_time, &lastn);
      sleep (1);
    }
}
