!   (c) gafit toolkit 2014
!   
!   LSEXDATA
  
      PROGRAM lsexdata
      
      USE fitterdata
      
      IMPLICIT NONE
      
      debug=.false.

      CALL settings
      CALL dimexpander
      CALL reader
      CALL writer
      stop  
      END
      
      SUBROUTINE writer
      USE fitterdata
      INTEGER i,j,k,l
      write(*,'("Individuals=",i3)')individuals
      write(*,'("Calculus per individual=",i3)') calcperind
      do i=1,individuals
      	if(hasdata(i)) then
         do j=1,calcperind
      	  if(hasheat(i,j)) then
      	  print *,'ind=',i,'calc=',j,'HEATFCAL=',fheatfcal(i,j),
     +          'HEATFJUL=',fheatfjul(i,j)
          endif
          if(hascoor(i,j)) then
      	  print *,'ind=',i,'calc=',j,'NUMATOMS=',numatoms(i,j)
             do k=1,numatoms(i,j)
      	 	print *,'ind=',i,'calc=',j,'atom=',k,atoms(i,j,k),
     +                  ' ',xyz(i,j,k,1),xyz(i,j,k,2),xyz(i,j,k,3)  
      	     enddo
      	  endif
      	  if(hasfreq(i,j)) then
          print *,'ind=',i,'calc=',j,'NUMFREQ=',numfreq(i,j)
          do k=1,numfreq(i,j)
                print *,'ind=',i,'calc=',j,'freq=',k,freqs(i,j,k)
          enddo
          endif
          if(hasgrad(i,j)) then
          do k=1,3*numatoms(i,j)
                print *,'ind=',i,'calc=',j,
     +           'param=',k,'grad=',grads(i,j,k)
          enddo
          endif
          if(numstates(i,j).ne.0) then
           print *,'ind=',i,'calc=',j,
     +            'n states=',numstates(i,j)
           if(hasdipxyz(i,j))then
             do k=1,numstates(i,j)
              print *,'ind=',i,'calc=',j,
     +           'dipx=', dipxyz(i,j,k,1),
     +           'dipy=', dipxyz(i,j,k,2),
     +           'dipz=', dipxyz(i,j,k,3)
             enddo
           endif
           do k=1,3
            do l=1, numstates(i,j)
              if(hasstates(i,j,k,l)) then
                print *,'ind=',i,'calc=',j,
     +            'state=',statesl(k),'order=',l,
     +            'eel=',states(i,j,k,l)
              endif
            enddo
           enddo
          endif
      	 enddo
      	else
      	 print *,'individual=',i,' has no data'
      	endif
      enddo
      END

  
      SUBROUTINE settings
      USE fitterdata
      IMPLICIT NONE
      CHARACTER*100 s
      INTEGER args,len,status
! defaults
      filedata='extracted.data'
      args=command_argument_count()
      IF (args.lt.1) GO TO 20
  
      CALL get_command_argument (1, s, len, status)
      IF (status.ne.0) GO TO 10
  
! convert string to integer
      READ (s,'(i10)') individuals
      IF (individuals.lt.1) GO TO 20
  
      IF (args.gt.1) THEN
        CALL get_command_argument (2, filedata, len, status)
        IF (status.ne.0) GO TO 10
      END IF
      IF (args.gt.2) THEN
        GO TO 10
      END IF
      if(debug) then
        PRINT *,'lsexdata'
        PRINT *,'--------------------------------'
        PRINT *,'individuals:       ',individuals
        PRINT *,'extracted data:    ',filedata
        PRINT *,'--------------------------------'
      endif
      RETURN
  
   10 CONTINUE
      PRINT *,'command line arguments error'
      STOP
  
   20 CONTINUE
      PRINT *,' lsexdata v0.1(c)GAFit toolkit -  2014'
      PRINT *,' Usage: lsexdata #individuals [file-data]'
      STOP
      END
  
      
