/*
(c) GAFit toolkitk $Id: injector.c 181 2016-07-12 10:21:58Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../inputline/line.h"
#include "../nullist/nllist.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../flyctl/flyctl.h"
#include "mopac.h"

extern char *CoefsTemplate;

extern char *ExternalInput;
extern char *ExternalFit;
extern char *Bounds;
extern char *MopacTemplate;
extern char *MopacMop;

extern char **names;
extern char **atoms;
extern double *coefs;

char *ExternalType = NULL;


//autoconfigure
void
mopacResponse (int ncoefs)
{
  FILE *r;
  int i;
  r = fopen ("response", "w");
  if (!r)
    {
      printf ("Cannot open file 'response'\n");
      fcStopIt ("injector mopacResponse\n");
    }
  fprintf (r, "\n");
  fprintf (r, "[job]\n");
  fprintf (r, "type: %s\n", ExternalType);
  fprintf (r, "coefficients: %d\n", ncoefs);
  fprintf (r, "external input: %s\n", ExternalInput);
  fprintf (r, "external fit: %s\n", ExternalFit);
  fprintf (r, "bounds: %s\n", Bounds);
  fprintf (r, "\n");
  fprintf (r, "[coefficient names]\n");
  for (i = 0; i < ncoefs; i++)
    fprintf (r, "%s %s\n", names[i], atoms[i]);
  fclose (r);
  return;
}

int
main (int argc, char **argv)
{
  int indv, n;
  char *p = NULL;

  fcStartFly ();

  if (argc == 1)
    {
      printf ("\nmopac injector v0.1 (c)GAFit toolkit - 2012\n");
      printf ("\tUsage: %s number-of-vectors [bulk]\n\n", argv[0]);
      exit (EXIT_SUCCESS);
    }
  else if (argc > 3)
    {
      printf ("Error!\n");
      fcStopIt ("injector: number of arguments\n");
    }
  else
    {
      if (argc == 3)
	{
	  if (!(strcmp (argv[2], "bulk")))
	    p = EXTERNAL_TYPE_BULK;
	  else
	    printf ("Error: defaults to external\n");
	}
      if (!p)
	p = EXTERNAL_TYPE_NORMAL;
      ExternalType = (char *) malloc ((strlen (p) + 1) * sizeof (char));
      strcpy (ExternalType, p);
      indv = atoi (argv[1]);
      InitEnvironmentVariables ();
      n = CountCoefficients ();
      if (indv == 0)
	{
	  mopacResponse (n);
	}
      else
	{
	  unlink ("response");
	  CreateMopacMop (0, indv, MopacTemplate, MopacMop);
	  CreateExternals (indv, n, ExternalInput);
	}
    }
}
