!   (c) gafit toolkit 2012
!   FITTER
! 
  
  
      PROGRAM fitter
      
      USE fitterdata
      USE conddata
      
      IMPLICIT NONE
      DOUBLE PRECISION userfit
      
      CALL fcCheck
      
      debug=.false.

      CALL settings
      CALL dimexpander
      CALL reader
      CALL readcond
      
      open (11,file=filefit,err=10)
      do hiddencounter=1,individuals
c        if(hasdata(hiddencounter)) then
            fit(hiddencounter)=userfit()
c        else
c            fit(hiddencounter)=penalty
c        endif
      if(toolsoutput) then
        print *,' individual ',hiddencounter, ' fit=',fit(hiddencounter)
      endif
        write( 11,*) fit(hiddencounter)
      enddo
      close(11)
      stop
   10 print *,'error ',filefit
      call fstopit('fitter main: cannot open file')
      stop  
      END
      

  
      SUBROUTINE settings
      USE fitterdata
      IMPLICIT NONE
      CHARACTER*100 s
      INTEGER args,len,status
! defaults
      filedata='extracted.data'
      call getfiledata(filedata//char(0))
      filefit='mopac.fit'
      call getfilefit(filefit//char(0))
      filecond='conditions.txt'
      call getfilecond(filecond//char(0))
      
      toolsoutput=.FALSE.
      call GET_ENVIRONMENT_VARIABLE("TOOLS_OUTPUT",s)
      IF (s.eq.'yes' .or. s.eq.'YES') THEN
        toolsoutput=.TRUE.
      ENDIF
      
      args=command_argument_count()
      IF (args.lt.1) GO TO 20
  
      CALL get_command_argument (1, s, len, status)
      IF (status.ne.0) GO TO 10
  
! convert string to integer
      READ (s,'(i10)') individuals
      IF (individuals.lt.1) GO TO 20
  
      IF (args.gt.1) THEN
        CALL get_command_argument (2, filedata, len, status)
        IF (status.ne.0) GO TO 10
      END IF
      IF (args.gt.2) THEN
        CALL get_command_argument (3, filefit, len, status)
        IF (status.ne.0) GO TO 10
      END IF
      IF (args.gt.3) THEN
        CALL get_command_argument (4, filecond, len, status)
        IF (status.ne.0) GO TO 10
      END IF
      IF (args.gt.4) THEN
        GO TO 10
      END IF
      if(debug) then
        PRINT *,'fitter'
        PRINT *,'--------------------------------'
        PRINT *,'individuals:       ',individuals
        PRINT *,'extracted data:    ',filedata
        PRINT *,'gafit external fit:',filefit
        PRINT *,'fitter conditions: ',filecond
        PRINT *,'--------------------------------'
      endif
      RETURN
  
   10 CONTINUE
      PRINT *,'command line arguments error'
      call fstopit('fitter settings: cmd line')
      STOP
  
   20 CONTINUE
c      PRINT *,'at least, the number of individuals is required'
c      call fstopit('fitter setings: #individuals')
      PRINT *,'fitter v0.1 (c)GAFit toolkit - 2012'
      PRINT *,' Usage: fitter #vectors [file-dat [file-fit [file-con]]]'
      STOP
      END
  
      subroutine readcond
      USE fitterdata
      USE conddata
      implicit none
      character*150 s
      character*4 cmd
      logical pass,isok
      integer lines,i
      pass=.false.
      penalty=1.0e10
      lines=0
      do while(.true.)
      
       if(pass) then
        allocate(icmd(lines))
        allocate(icalc(lines))
        allocate(aint1(lines))
        allocate(aint2(lines))
        allocate(aint3(lines))
        allocate(aint4(lines))
        allocate(dvalue(lines))
        allocate(dw(lines))
       endif
       
       lines=1
       
       open (11,file=filecond,err=10,status='old')
       do while(.true.)
        read (11,'(a)',end=30) s
        if(pass) then
         icmd(lines)=0
         icalc(lines)=0
         aint1(lines)=0
         aint2(lines)=0
         aint3(lines)=0
         aint4(lines)=0
         dvalue(lines)=0.0
         dw(lines)=0.0
        endif
      
        isok=.true.
      
        read (s,'(a4)') cmd
        
        if (cmd.eq.'heat') then
      	 if(pass) then
      	  read(s,*) cmd, icalc(lines), dvalue(lines), dw(lines)
          icmd(lines)=1
         endif
        else if (cmd.eq.'freq') then
         if(pass) then
      	  read(s,*) cmd, icalc(lines), aint1(lines),dvalue(lines), 
     +              dw(lines)
          icmd(lines)=2
         endif
        else if (cmd.eq.'dist') then
      	 if(pass) then
      	  read(s,*) cmd, icalc(lines),aint1(lines),aint2(lines),
     +              dvalue(lines),dw(lines)
          icmd(lines)=3
         endif
        else if (cmd.eq.'angl') then
         if(pass) then
          read(s,*)cmd,icalc(lines),aint1(lines),aint2(lines),
     +              aint3(lines),dvalue(lines),dw(lines)
          icmd(lines)=4
      	 endif
        else if (cmd.eq.'dihe') then
         if(pass) then
          read(s,*)cmd,icalc(lines),aint1(lines),aint2(lines),
     +              aint3(lines),aint4(lines),dvalue(lines),dw(lines)
          icmd(lines)=5
         endif
        else if (cmd.eq.'delt') then
         if(pass) then
          read(s,*)cmd,icalc(lines),aint1(lines),
     +              dvalue(lines),dw(lines)
          icmd(lines)=6
         endif
        else if (cmd.eq.'grad') then
         if(pass) then
      	  read(s,*) cmd, icalc(lines), aint1(lines),dvalue(lines), 
     +              dw(lines)
          icmd(lines)=7
         endif
        else if(cmd.eq.'dipx') then
c         cmd calculo estado valor peso        
         if(pass) then
          read(s,*) cmd,icalc(lines),aint1(lines),dvalue(lines),
     +              dw(lines)
          icmd(lines)=8
         endif      
        else if(cmd.eq.'dipy') then
c         cmd calculo estado valor peso        
         if(pass) then
          read(s,*) cmd,icalc(lines),aint1(lines),dvalue(lines),
     +              dw(lines)
          icmd(lines)=9
         endif      
        else if(cmd.eq.'dipz') then
c         cmd calculo estado valor peso        
         if(pass) then
          read(s,*) cmd,icalc(lines),aint1(lines),dvalue(lines),
     +              dw(lines)
          icmd(lines)=10
         endif      
        else if(cmd.eq.'eel') then
c         cmd calculo estado valor peso        
         if(pass) then
          read(s,*) cmd,icalc(lines),aint1(lines),aint2(lines),
     +        dvalue(lines),dw(lines)
          icmd(lines)=11
         endif      
        else if (cmd.eq.'pena') then
         if (pass) then
         read(s,*)cmd,penalty
          lines=lines-1
         endif
        else if (cmd.eq.'') then
         isok=.false.
        else
      	 print *,'fitter conditions ERROR:',s
      	 isok=.false.
        endif

        if(isok) then
         lines=lines+1
        endif

       enddo
       
   30  continue
       close(11)
       
       if(pass) goto 20

       pass=.true.

      enddo
   
      stop
   
   20 continue
      lines=lines-1
      conditions=lines

      if (debug) then
      print *,'End reading conditions data'
      print *,'i ','cmd ','calc ','int1 ','int2 ',
     +        'int3 ','int4 ',
     +        'dvalue ','weight '
      do i=1,lines
      print *,i,icmd(i),icalc(i),aint1(i),aint2(i),aint3(i),aint4(i),
     +        dvalue(i),dw(i)
      enddo
      endif

      if(conditions.lt.2) then
      call fstopit('fitter readcond: conditions')
      endif

      if(penalty.eq.0) then
      print *,'penalty must be set'
      call fstopit('fitter readcond: penalty')
      endif


      return
   10 print *,'error'
      call fstopit('fitter readcond: conditions.txt')
      stop
      end
      
     
