!   (c) Roberto Rodriguez Fernandez 2012
!   FITTER
! 
  
      MODULE fitterdata
      IMPLICIT NONE
      SAVE
      CHARACTER*256 ::filedata,filefit,filecond
      INTEGER ::individuals
      INTEGER ::calcperind
      DOUBLE PRECISION ,allocatable::fheatfcal(:,:)
      DOUBLE PRECISION ,allocatable::fheatfjul(:,:)
      INTEGER ,allocatable::numatoms(:,:)
      CHARACTER ,allocatable::atoms(:,:,:)*2
      DOUBLE PRECISION ,allocatable::xyz(:,:,:,:)
      INTEGER ,allocatable::numfreq(:,:)
      DOUBLE PRECISION ,allocatable::freqs(:,:,:)
      DOUBLE PRECISION ,allocatable::grads(:,:,:)
      INTEGER, allocatable::numstates(:,:)
      DOUBLE PRECISION, allocatable::dipxyz(:,:,:,:)
      DOUBLE PRECISION, allocatable::states(:,:,:,:)
      INTEGER hiddencounter
      DOUBLE PRECISION, allocatable::fit(:)
      LOGICAL, allocatable::hasdata(:)
      LOGICAL, allocatable::hasheat(:,:)
      LOGICAL, allocatable::hascoor(:,:)
      LOGICAL, allocatable::hasfreq(:,:)
      LOGICAL, allocatable::hasgrad(:,:)
      LOGICAL, allocatable::hasdipxyz(:,:)
      LOGICAL, allocatable::hasstates(:,:,:,:)

      CHARACTER (len = 8), dimension (3) :: statesl 

      LOGICAL :: debug
      LOGICAL :: toolsoutput
      END
      
      MODULE conddata
      IMPLICIT NONE
      SAVE
      integer, allocatable :: icmd(:),icalc(:),aint1(:)
      integer, allocatable :: aint2(:),aint3(:),aint4(:)
      double precision, allocatable :: dvalue(:),dw(:)
      double precision penalty
      integer conditions
      END
      
      SUBROUTINE dimexpander
      USE fitterdata
      IMPLICIT NONE
      INTEGER i,calc,cmd,istate,iorder
      INTEGER matoms,mfreq,mstates
      matoms=0
      mfreq=0
      mstates=0
      
      statesl(1)='SINGLET'
      statesl(2)='DOUBLET'
      statesl(3)='TRIPLET'

      OPEN (11,file=filedata,status="old",err=20)
      DO WHILE (.true.)
        READ (11,*,end=10) i,calc,cmd
        IF (cmd.eq.6) THEN
          READ (11,*,end=20) calcperind
        ELSE IF (cmd.eq.2) THEN
          READ (11,*,end=20) i
          IF (i.gt.matoms) matoms=i
        ELSE IF (cmd.eq.4) THEN
          READ (11,*,end=20) i
          IF (i.gt.mfreq) mfreq=i
        ELSE IF (cmd.eq.8) THEN
          READ (11,*,end=20) i
          IF (i.gt.mstates) mstates=i
        ELSE
          READ (11,*)
        END IF
      END DO
   10 CONTINUE
      CLOSE (11)
      allocate(fheatfcal(individuals,calcperind))
      allocate(fheatfjul(individuals,calcperind))

      allocate(numatoms(individuals,calcperind))
      allocate(atoms(individuals,calcperind,matoms))
      allocate(xyz(individuals,calcperind,matoms,3))

      allocate(numfreq(individuals,calcperind))
      allocate(freqs(individuals,calcperind,mfreq))
      allocate(grads(individuals,calcperind,matoms*3))

      allocate(numstates(individuals,calcperind))
      allocate(dipxyz(individuals,calcperind,mstates,3))
c     3->SINGLET, DOUBLET AND TRIPLET. 
c     (individuals,calperind,state,order)
      allocate(states(individuals,calcperind,3,mstates))
      
      allocate(fit(individuals))

      allocate(hasdata(individuals))
      allocate(hasheat(individuals,calcperind))
      allocate(hascoor(individuals,calcperind))
      allocate(hasfreq(individuals,calcperind))
      allocate(hasgrad(individuals,calcperind))

      allocate(hasdipxyz(individuals,calcperind))
c see above
      allocate(hasstates(individuals,calcperind,3,mstates))

      do i=1,individuals
        fit(i)=0
        hasdata(i)=.false.
        do calc=1,calcperind
          hasheat(i,calc)=.false.
          hascoor(i,calc)=.false.
          hasfreq(i,calc)=.false.
          hasgrad(i,calc)=.false.
          hasdipxyz(i,calc)=.false.
          numstates(i,calc)=0;
c 1,2,3 singlet, doublet, triplet          
          do istate=1,3
            do iorder=1,mstates
              hasstates(i,calc,istate,iorder)=.false.
            enddo
          enddo
        enddo
      enddo
      RETURN
  
   20 CONTINUE
      PRINT *,'error:',filedata
      PRINT *,'fitter dimexpander: extracted data'
      stop
      END
  
      SUBROUTINE cmdtype (icmd, datatype)
      INTEGER icmd
      CHARACTER*(*) datatype
      IF (icmd.eq.0) datatype='HEATFCAL'
      IF (icmd.eq.1) datatype='HEATFJUL'
      IF (icmd.eq.2) datatype='NUMATOMS'
      IF (icmd.eq.3) datatype='CARTESIAN'
      IF (icmd.eq.4) datatype='NUMFREQ'
      IF (icmd.eq.5) datatype='FREQUENCIES'
      IF (icmd.eq.6) datatype='CALCPERIND'
      IF (icmd.eq.7) datatype='GRADIENTS'
      IF (icmd.eq.8) datatype='NUMCONF'
      IF (icmd.eq.9) datatype='DIPXYZ'
      IF (icmd.eq.10) datatype='EEL'
      RETURN
      END
  
      SUBROUTINE reader
      USE fitterdata
      INTEGER i,calc,cmd,dummy
      INTEGER at,state,order
      CHARACTER*2 sat
      DOUBLE PRECISION x,y,z,fr,eel
      CHARACTER*15 ctype
      INTEGER index

      index=0 
      OPEN (11,file=filedata,status="old",err=20)
      DO WHILE (.true.)
        index=index+2
        READ (11,*,end=10) i,calc,cmd
        if(cmd.ne.6) hasdata(i+1)=.true.
        CALL cmdtype (cmd, ctype)
        IF (cmd.eq.0) THEN
          READ (11,*,end=10) fheatfcal(i+1,calc+1)
          hasheat(i+1,calc+1)=.true.
        ELSE IF (cmd.eq.1) THEN
          READ (11,*,end=10,err=40) fheatfjul(i+1,calc+1)
        ELSE IF (cmd.eq.2) THEN
          READ (11,*,end=10) numatoms(i+1,calc+1)
        ELSE IF (cmd.eq.3) THEN
          READ (11,*,end=10) at,sat,x,y,z
          atoms(i+1,calc+1,at)=sat
          xyz(i+1,calc+1,at,1)=x
          xyz(i+1,calc+1,at,2)=y
          xyz(i+1,calc+1,at,3)=z
          hascoor(i+1,calc+1)=.true.
        ELSE IF (cmd.eq.4) THEN  
          READ (11,*,end=10) numfreq(i+1,calc+1)
        ELSE IF (cmd.eq.5) THEN
          READ (11,*,end=10) at,fr
          freqs(i+1,calc+1,at)=fr
          hasfreq(i+1,calc+1)=.true.
        ELSE IF (cmd.eq.6) THEN
          READ (11,*,end=10) dummy
          IF (dummy.ne.calcperind) THEN
            PRINT *,ctype,' twice or more defined'
          END IF
        ELSE IF (cmd.eq.7) THEN
          READ(11,*,end=10) at,fr
          grads(i+1,calc+1,at)=fr
          hasgrad(i+1,calc+1)=.true.
        ELSE IF (cmd.eq.8) THEN
          READ(11,*,end=10) numstates(i+1,calc+1)
        ELSE IF (cmd.eq.9) THEN
          READ(11,*,end=10) state,x,y,z
          dipxyz(i+1,calc+1,state,1)=x
          dipxyz(i+1,calc+1,state,2)=y
          dipxyz(i+1,calc+1,state,3)=z
          hasdipxyz(i+1,calc+1)=.true.
        ELSE IF (cmd.eq.10) THEN
          READ(11,*,end=10) state,order,eel
          if((state.lt.1).or.(state.gt.3)) then
            print *,'error state=',state,'order=',order,'eel=',eel
            stop
          endif
          states(i+1,calc+1,state,order)=eel
          hasstates(i+1,calc+1,state,order)=.true. 
        END IF
      END DO
   10 CONTINUE
      CLOSE (11)
      RETURN
   20 CONTINUE
      PRINT *,'error:',filedata
      RETURN
   40 CONTINUE
      print *,'170 ',filedata,' line=',index
      print *,'i=',i,'calc=',calc,'cmd=',cmd
      call fstopit('170 error')
      stop
      END
