/*
(c) GAFit toolkit $Id: literals.c 24 2015-02-10 23:50:10Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "literals.h"
char *alfa = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
char *
revletters (char *let)
{
  int i;
  int l = strlen (let);
  char tmp;
  for (i = 0; i < l / 2; i++)
    {
      tmp = let[i];
      let[i] = let[l - i - 1];
      let[l - i - 1] = tmp;
    }
  return let;
}

int
charpos (char c)
{
  int i;
  int l = strlen (alfa);
  for (i = 0; i < l; i++)
    if (c == alfa[i])
      return i;
  return -1;
}

//literals must be freed'!!
char *
literal (void)
{
  return malloc (sizeof (char) * _MAX_COEF_LITERAL_LEN_);
}

char *
Letters (int i)
{
  char *letters = literal ();
  int l = strlen (alfa);
  int r;
  int a = 2;
  char *pos = letters;
  while (i >= l)
    {
      if (++a > _MAX_COEF_LITERAL_LEN_)
	{
	  printf ("Increase _MAX_COEF_LITERAL_LEN_\n");
	  exit (EXIT_FAILURE);
	}
      r = i % l;
      i = (i - r) / l - 1;
      sprintf (pos++, "%c", alfa[r]);
    }
  sprintf (pos, "%c", alfa[i]);
  return revletters (letters);
}

int
Srettel (char *let)
{
  char *p, *letters = literal ();
  int l = strlen (alfa);
  int n, r;
  strcpy (letters, let);
  n = charpos (letters[0]);
  p = letters;
  if (strlen (p) >= 2)
    while (strlen (p) > 1)
      {
	p++;
	r = charpos (p[0]);
	n = (n + 1) * l + r;
      }
  free (letters);
  return n;
}
