/*
 (c)GAFit toolkit $Id: job.h 326 2018-07-27 13:36:52Z ro $
*/

#ifndef _JOB_H_
#define _JOB_H_

#include "core.h"

typedef struct
{
  //***********************************************************
  int elite;			// elistist strategy? (0 = no; 1 = yes)
  int size_k;			// tournament selection size
  int mutation_type;		// mutation operator
  int mutation_integer;		// Mutation operator for integer variables
  int cx_type;			// crossover operator
  double p_cx;			// crossover rate
  double blx_alpha,		//mutation rate
    eta_sbx, sigma, p_mt;
}
GAPARAMETERS;

typedef struct
{
  char *file;			// default INPUT_FILE_JOB
  //**********************************************************
  unsigned int test;		// test mode random seed
  int runs;			// number of runs
  int evaluations;		// number of generations
  int pop_size;			// population size
  int dir;			// direction
  //*********************************************************
  GAPARAMETERS ga;		// genetic algorithm parameters
  //*********************************************************
  vect_domain bounds;
  //*********************************************************
  int jobtype;
  int N;			//number of coefs
  int external_coefs;		//idem
  int ncoefs;			//number of coeficients per interaction
  char *external_command;
  char *external_input;
  char *external_fit;
  char *external_bounds;
  int final_evaluation;		//to execute an evaluation after finish
  int last_print;		// file print control
  //********************************************************
  int print_run;		//PrintRun
  int print_ga;			//PrintGa
  ind all_time_best;		// best individual found for all RUNS
  //********************************************************
  p_ind population;		//old population
  p_ind new_population;		//current population
  ind best;
  ind new_best;
} JOB;

void initJob (JOB * j);
void cleanJob (JOB * j);
void initBest (JOB * j);
void swapPopulation (JOB * j);
#endif
