/*
 (c)GAFit toolkit $Id: job.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include "core.h"
#include "job.h"

//N must be set to use this function
void
initBest (JOB * j)
{
  j->all_time_best.genes = malloc (sizeof (double) * j->N);
  j->all_time_best.fitness = -1.0;
}


void
initJob (JOB * j)
{
  j->file = strdup (INPUT_FILE_JOB);
  j->final_evaluation = 0;
  j->print_run = 0;
  j->runs = 1;
}

void
cleanJob (JOB * j)
{
  free (j->all_time_best.genes);
}

void
swapPopulation (JOB * j)
{
  p_ind temp;
  temp = j->population;
  j->population = j->new_population;
  j->new_population = temp;
}
