/*
 (c)GAFit toolkit $Id: ufpu.c 306 2017-08-16 22:38:53Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#if defined(__APPLE__) && defined(__MACH__)
#include <stdlib.h>
#else
#include <malloc.h>
#endif
#include "../analytical/analytical.h"
#include "../fpu/fpu.h"
#include "../nullist/nllist.h"
int
main (void)
{
  int i;
  int flags = 0;
  char file[] = "prog";
  char job[] = "job.txt";
  double potential;
  double distance;
  double *coefs;
  char c;

  printf ("uFpu v0.2 (c)GAFit toolkit - 2013\n\n");

  anCheckAnalytical (job, file, 1);
  while (1)
    {
      printf ("INPUT\n");
      coefs = (double *) malloc (sizeof (double) * anGetNCoefs ());

      potential = 0;

      printf ("\tdistance variable (%s)=", anDistVar ());
      scanf ("%lf", &distance);

      for (i = 0; i < anGetNCoefs (); i++)
	{
	  printf ("\tcoefficient %s=", anCoefVar (i));
	  scanf ("%lf", &coefs[i]);
	}

      flags = anSetAndRun (&potential, distance, coefs, 1);

      if (flags)
	{
	  printf ("\nERROR:\t");
	  fpuExplainStatus (flags);
	  printf ("\n");
	}
      else
	printf ("\nRESULT POTENTIAL:%lf\n\n", potential);
      free (coefs);
      printf ("Press 'q'/INTRO to quit, another key/INTRO to repeat\n");
      while ((c = getchar ()) == '\n');
      if (c == 'q')
	break;
    }
  anClearAll ();
  return 0;
}
