c POTENTIALS 
c sets the number of coefs required by potential
c (*@\label{setcoefs}@*)
      integer function setcoefs(potential)
      implicit none
      integer potential
      integer angetncoefs
      integer usetcoefs
      external angetncoefs
      if (potential .eq. -1) then
        setcoefs=usetcoefs()
      else if (potential .eq. 0) then
      	setcoefs=angetncoefs()
      else if (potential .eq. 1) then
      	setcoefs=4
      else if (potential .eq. 2) then
      	setcoefs=6
      else if (potential .eq. 3) then
        setcoefs=8
      else if(potential.eq.4) then
        setcoefs=2
      else
      	stop 'setcoefs: not implemented'
      endif
      end
      
c if a charge file is needed
c (*@\label{getcharges}@*)
      logical function getcharges(potential)
      implicit none
      integer potential
      logical ugetcharges
      if (potential .eq. -1) then
      	getcharges=ugetcharges()
      else if (potential .eq. 0) then
      	getcharges=.false.
      else if (potential .eq. 1) then
      	getcharges=.false.
      else if (potential .eq. 2) then
      	getcharges=.false.
      else if (potential .eq. 3) then
        getcharges=.false.
      else if(potential.eq.4) then
       getcharges=.true.
      else
      	stop 'getcharges: not implemented'
      endif
      end
      
c Potential Router, route calculations to the desired potential  
c (*@\label{potRouter}@*)
      subroutine  potRouter(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo
      double precision vpot, x(nmax)
      if (potential .eq. -1) then
        call userpot(geo,x,nmax,vpot)      
      else if (potential .eq. 0) then
      	call pot0(geo,x,nmax,vpot)
      else if (potential .eq. 1) then
      	call pot1(geo,x,nmax,vpot)
      else if (potential .eq. 2)then
        call pot2(geo,x,nmax,vpot)
      else if (potential .eq. 3) then
      	call pot3(geo,x,nmax,vpot)
      else if(potential .eq.4) then
        call pot4(geo,x,nmax,vpot)
      else
      	stop 'not implemented potential'
      endif
      end

c Curve Router, route calculations to the desired potential   
c (*@\label{curRouter}@*)   
      subroutine  curRouter(d,atom1,atom2,x,nmax,vpot)
      use vglobales
      integer nmax,atom1,atom2,index
      double precision vpot, x(nmax),d
      double precision analytical,userv,v1,v2,v3,v4
      integer ix
      if (potential .eq. -1) then
        vpot=userv(d,atom1,atom2,x,nmax)
      else if (potential .eq. 0) then
      	index=ix(atom1,atom2,1)
      	vpot=analytical(d,index,x)
      else if (potential .eq. 1) then
      	vpot=V1(d,atom1,atom2,x,nmax)
      else if (potential .eq. 2)then
      	vpot=V2(d,atom1,atom2,x,nmax)
      else if (potential .eq. 3) then
        vpot=V3(d,atom1,atom2,x,nmax)
      else if(potential .eq.4) then
      	vpot=V4(d,atom1,atom2,x,nmax,q(atom1),q(atom2))
      else
      	stop 'not implemented potential'
      endif
      end

c Now, each potential calculation down from here.

c     0-------analytical--------------
      subroutine pot0(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo,i,j,k,index
      double precision d,vpot,analytical
      external analytical
      double precision X(nmax)
      integer ix
      vpot=0.0d0
      do i=1,nprox
       do j=1,nsam
       k=j+nprox
       d=r(geo,i,k)
       index=ix(i,k,1)
       vpot=vpot+analytical(d,index,x)
       enddo
      enddo
      return
      end

c     1------------------------------
      subroutine pot1(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo,i,j,k
      double precision d,vpot,V1
      double precision X(nmax)
      vpot=0.0d0
      do i=1,nprox
       do j=1,nsam
       k=j+nprox
       d=r(geo,i,k)
       vpot=vpot+V1(d,i,k,x,nmax)
       enddo
      enddo
      return
      end

      FUNCTION V1(r,i,j,x,m)
      implicit none
      integer i,j,m,ix
      dimension x(m)
      double precision x,r,a,b,c,d,v1
      A=x(ix(i,j,1))
      B=x(ix(i,j,2))
      C=x(ix(i,j,3))
      D=x(ix(i,j,4))
      V1=A*EXP(-B*R)+C/R**D
      RETURN
      END

c     2------------------------------
      subroutine pot2(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo,i,j,k
      double precision d,vpot,V2
      double precision X(nmax)
      vpot=0.0d0
      do i=1,nprox
       do j=1,nsam
       k=j+nprox
       d=r(geo,i,k)
       vpot=vpot+V2(d,i,k,x,nmax)
       enddo
      enddo
      return
      end

      FUNCTION V2(r,i,j,x,m)
      implicit none
      integer i,j,m,ix
      dimension x(m)
      double precision x,r,a,b,c,d,e,f,v2
      A=x(ix(i,j,1))
      B=x(ix(i,j,2))
      C=x(ix(i,j,3))
      D=x(ix(i,j,4))
      E=x(ix(i,j,5))
      F=x(ix(i,j,6))
      V2=A*EXP(-B*R)+C/R**D+E/R**F
      RETURN
      END


c     3------------------------------
      subroutine pot3(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo,i,j,k
      double precision d,vpot,V3
      double precision X(nmax)
      vpot=0.0d0
      do i=1,nprox
       do j=1,nsam
       k=j+nprox
       d=r(geo,i,k)
       vpot=vpot+V3(d,i,k,x,nmax)
       enddo
      enddo
      return
      end

      FUNCTION V3(r,i,j,x,m)
      implicit none
      integer i,j,m,ix
      dimension x(m)
      double precision x,r,a,b,c,d,e,f,g,h,v3
      A=x(ix(i,j,1))
      B=x(ix(i,j,2))
      C=x(ix(i,j,3))
      D=x(ix(i,j,4))
      E=x(ix(i,j,5))
      F=x(ix(i,j,6))
      G=x(ix(i,j,7))
      H=x(ix(i,j,8))
      V3=A*EXP(-B*R)+C/R**D+E/R**F+G/R**H
      RETURN
      END

c     4------------------------------
      subroutine pot4(geo,x,nmax,vpot)
      use vglobales
      integer nmax,geo,i,j,k
      double precision d,vpot,V4
      double precision X(nmax)
      vpot=0.0d0
      do i=1,nprox
       do j=1,nsam
       k=j+nprox
       d=r(geo,i,k)
       vpot=vpot+V4(d,i,k,x,nmax,q(i),q(j))
       enddo
      enddo
      return
      end

      FUNCTION V4(r,i,j,x,m,qi,qj)
      implicit none
      integer i,j,m,ix
      dimension x(m)
      double precision x,r,a,b
      double precision v4,qi,qj
      A=x(ix(i,j,1))
      B=x(ix(i,j,2))
      V4=A*((B/R)**12-(B/R)**6)+qi*qj/R*332.0532d0
      RETURN
      END


