/*
(c) GAFit toolkit $Id: intpot.c 398 2021-10-05 15:37:17Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "intpot.h"
#include "final.h"
#include "../flyctl/flyctl.h"
#include "../job.h"

char *ExternalType = NULL;


int
main (int argc, char **argv)
{
  JOB job;

  int indv;
  char *p = NULL;

  initJob (&job);
  fcStartFly ();

  if (argc == 1)
    {
      printf ("\n%s v0.1 (c)GAFit toolkit - 2017\n", argv[0]);
      printf ("\tUsage: %s number-of-vectors [bulk]\n\n", argv[0]);
      exit (EXIT_SUCCESS);
    }
  else if (argc > 3)
    {
      printf ("Error!\n");
      fcStopIt ("intermolecular: number of arguments\n");
    }
  else
    {
      if (argc == 3)
	{
	  if (!(strcmp (argv[2], "bulk")))
	    p = EXTERNAL_TYPE_BULK;
	  else
	    printf ("Error: defaults to external\n");
	}
      if (!p)
	p = EXTERNAL_TYPE_NORMAL;
      ExternalType = (char *) malloc ((strlen (p) + 1) * sizeof (char));
      strcpy (ExternalType, p);
      indv = atoi (argv[1]);
      InitEnvironmentVariables (&job);
      PrepareSystem (&job, !indv);
      if (indv == 0)
	{
	  WriteResponse (&job);
	}
      else if (indv > 0)
	{
	  unlink ("response");
	  RunEvaluation (indv, &job);
	}
      else
	FinalEvaluation (stdout, job.N, 1, NULL);
    }
  fflush (stdout);
}
