/*
 (c)GAFit toolkit $Id: interface.h 326 2018-07-27 13:36:52Z ro $
*/


// interface between fortran/C
#ifndef __interface__
#define __interface__
#include "../core.h"
#include "../job.h"
#define eval_f eval_f_
#define Reading reading_
#define GetPot getpot_
#define SetPot setpot_
#define GetAtom getatom_
#define GetNProx getnprox_
#define GetNSam getnsam_
#define GetPTypes getptypes_
#define GetSTypes getstypes_
#define GetCTypes getctypes_
#define GetDTypes getdtypes_
#define GetInteractions getinteractions_
#define GetIsUserInteractions getisuserint_
#define GetIsAllInteractions getisallint_
#define GetNCoefs getncoefs_
#define IndexType ix_
#define GetQ getq_
#define NeedQ needq_
#define GetGeom getgeom_
#define EvalGeo func_
#define GetEnergy getenergy_
#define GetWeight getweight_
#define SetAutoWeights setautow_
#define GetAutoWeights getautow_
#define GetAutoPrint getautoprt_
#define UpdateAutoWeights updatew_
#define GetOldType getotype_
#define GetNewType getntype_
#define GetOldQ getoldq_
#define SetPrintGeo setpgeo_
#define Curve curve_
#define SetFitting setfitting_
#define SetIntrxTypes setintrxtypes_

//NOTE: defines for analytical functions in 
//analytical/analytical.h

//fortran code
void eval_f (double *a, int *x, double *b);
double EvalGeo (double *a, int *m, int *geo);
int UpdateAutoWeights (double *a, int *m);
double Curve (double *d, int *atom1, int *atom2, double *x, int *nmax);
void Reading (char *file1, char *file2, char *file3, char *file4,
	      int *pot, int *ncoefs, long int a, long int b, long int c,
	      long int d);
//accessing fortran read variables            
void GetAtom (int *i, char *c);
int GetPot (void);
void SetPot (int *i);
int GetNProx (void);
int GetNSam (void);
int GetPTypes (void);
int GetSTypes (void);
int GetCTypes (void);
int GetDTypes (void);
int GetInteractions (void);
int GetIsUserInteractions (void);
int GetIsAllInteractions (void);
int IndexType (int *i, int *j, int *coef);
int GetNCoefs (void);
double GetQ (int *i);
int NeedQ (void);
int GetGeom (void);
double GetEnergy (int *i);
double GetWeight (int *i);
int SetAutoWeights (int *i, int *k);
int GetAutoWeights (void);
int GetAutoPrint (void);
int GetOldType (int *i);
int GetNewType (int *i);
double GetOldQ (int *i);
int SetFitting (int *i);
int SetIntrxTypes (int *i, int *j);
//setting and getting fortran print variables
int SetPrintGeo (int *i);
//C code =====================
void SetUnBuffered (void);
int ReadParameters (JOB * j, int prt);
vect_domain ReadJobInternal (JOB * j, int prt);
vect_domain ReadJobExternal (JOB * j, int prt);
int
ReadFJob (JOB * j, char *f1, char *f2, char *f3, char *f4, char *fb,
	  int *pot, int *rcoef,
	  int *prtgeo, int *prtrun, int *fit, int *prtga, int *prtan,
	  int *autow, int *autowp, int *interactions, int *nint);
void ReadJobType (JOB * j, int prt);
#endif
