c interface between fortran source files
c and between fortran and C code
c see inteface.h and eval.f too
      module vglobales
      implicit none
      save
      double precision, allocatable :: r(:,:,:)
      double precision, allocatable :: v(:),w(:),wdelta(:),wtol(:)
      double precision, allocatable :: q(:)
      double precision, allocatable :: xyz(:,:)
      integer, allocatable :: types(:)
      integer, allocatable :: wtype(:)
      integer, allocatable :: type2int(:,:)
      integer :: geometries,nprox,nsam,natom
c     types in A, types in B, total types, common types and 
c     types with more than one atom
      integer :: ptypes,stypes,ntypes,ctypes,dtypes
      integer :: potential
c     interactions types: false=inter, true=inter+intra
      logical :: intratypes,userdefined 
      integer :: interactions
      integer :: coeficients
      logical :: charges
      integer :: fittingtype
      logical :: autoweights
      character,allocatable :: atom(:)*2
      integer,allocatable :: oldtypes(:),tqt(:)
      double precision, allocatable :: oldqt(:)
      end module vglobales

      module printoptions
      implicit none
      save
      logical :: fprtgeo
      logical :: fprtrun
      logical :: fprtauw
      end module printoptions

c miscelaneus
      integer function setintrxtypes(i, num)
      use vglobales
      integer i,num
      if (i.eq.0) then
              intratypes=.false.
              userdefined=.false.
      else
              intratypes=.true.
              if(i.eq.2) then
                      userdefined=.true.
                      interactions=num
              endif
      endif
      setintrxtypes=0
      return
      end

      integer function setfitting(i)
      use vglobales
      integer i
      fittingtype=i
      setfitting=i
      return
      end
      
      integer function setpgeo(i)
      use printoptions
      integer i
      if(i.eq.0) then
       fprtgeo=.false.
      else
       fprtgeo=.true.
      endif
      setpgeo=1
      return
      end
      
c to address individual coefs from atom index      
      integer function ix(i,j,coef)
      use vglobales
      integer coef,i,j,interak
c if user defined you cannot use this
      if(userdefined) then
        STOP 'user-defined interactions: cannot use ix'
      endif
c      ix = ((types(i)-1)*stypes+(types(j)-ptypes)-1)*coeficients+coef
      interak=type2int(types(i),types(j))
      ix=(interak-1)*coeficients+coef 
      if (interak.le.0) then
           print *,'there is not interaction between i=',i,' and ',
     x    'j=',j
          stop 'interaction error'
      endif
      return
      end
      
c to read data files
      subroutine reading(fg,fe,fa2t,fq,pot,ncoefs) 
      use vglobales
      integer ncounter
      integer ndupl
      integer :: ncoefs
      integer pot
      character*(*) fg,fe,fa2t,fq
      character,allocatable :: symbol(:)*2
      integer i,j,k
c     character lx
c ,ly,lz
      real,allocatable ::  x(:),y(:),z(:)
      integer na,setcoefs
      integer gcount
      logical getcharges,stopit
c function isdupl
      logical isdupl 
      integer number
                  
      stopit=.false.
      ncoefs=setcoefs(pot)
      charges=getcharges(pot)
      if(charges) then
            if('none' .eq. fq)then
                  stop 'no charges file'
            endif
      endif       
      coeficients=ncoefs
      potential=pot
      
c begins atom2type reading      
c simplifiying input.
      open(11,file=fa2t,status="old",err=5)
c      read(11,*)ntypes,ptypes,stypes,nprox,natom
c we only need two parameters.
      read(11,*)nprox,natom
      nsam=natom-nprox
c      ttypes=ptypes*stypes
c      interactions=ttypes
c      these are calculated later
      allocate (types(natom))
      allocate (symbol(natom))      
      allocate (oldtypes(natom))
      do i=1,natom
       read(11,*,end=1)number,symbol(i),types(i)
       if(number.ne.i)then
             print *,'file ',fa2t,' atom number mismatch'
             stop
       endif
      enddo
      close(11)
      
      do i=1,natom
            oldtypes(i)=types(i)
      enddo      

c normalizing types      
      number=0
      do i=1,natom
            if(types(i).gt.0) then
              number=number-1
              do j=i+1,natom
                if(types(i).eq.types(j))then
                  types(j)=number
                endif
              enddo
              types(i)=number
            endif            
      enddo
      
      do i=1,natom
        types(i)=-types(i)
      enddo
c     fragment1 types
      ptypes=ncounter(natom,1,nprox,types)
c     fragment2 types
      stypes=ncounter(natom,nprox+1,natom,types)
c     total types in both fragments
      ntypes=ncounter(natom,1,natom,types)
c     types in common between the two fragments
      ctypes=ptypes+stypes-ntypes
c     interactions INTER
      if (intratypes) then
C     INTER+INTRA
c     INTER+INTRA or user defined? 
         if(.not.userdefined) then
           dtypes=ndupl(natom,types)
           interactions=int(ntypes*(ntypes-1)/2.0+dtypes)
         endif
      else
c     only INTER                
        interactions=int(ptypes*stypes-ctypes*(ctypes-1)/2.0)
      endif
      
      allocate(type2int(ntypes,ntypes))
      do i=1,ntypes
      do j=1,ntypes
       type2int(i,j)=-1
      enddo
      enddo
c creates interaction matrix type X type       
      number=0
      if(.not.intratypes) then
c if only INTER:      
c       print *,'inter'
        do i=1,nprox
          do j=nprox+1,natom
            if(type2int(types(i),types(j)).eq.-1) then
              number=number+1
              type2int(types(i),types(j))=number
              type2int(types(j),types(i))=number
c             print *,types(i),types(j),type2int(types(i),types(j))
            endif 
          enddo
        enddo
      else
c INTER + INTRA              
c       print *,'inter+intra'
         do i=1,natom
          do j=i+1,natom
            if(types(i).ne.types(j))then
            if(type2int(types(i),types(j)).eq.-1) then
              number=number+1
c             print *,i,j,'i=',types(i),'j=',types(j),'n=',number
              type2int(types(i),types(j))=number
              type2int(types(j),types(i))=number
            endif
            endif
          enddo
        enddo
c interactions between same type
       do i=1,natom
       if(isdupl(i,natom,types)) then
             number=number+1
             type2int(types(i),types(i))=number
             exit
          endif
       enddo    
      endif
c      print *,'ptypes=',ptypes
c      print *,'stypes=',stypes
c      print *,'ntypes=',ntypes
c      print *,'ctypes=',ctypes
c      print *,'numbers=',number
c       do i=1,ntypes
c         print *,(type2int(i,j),j=1,ntypes)
c       enddo
c end atom2type reading      

      if (charges) then
            open(12,file=fq,status="old",err=5)
            allocate (q(natom))
            allocate (oldqt(ntypes))

      allocate (tqt(ntypes))

        do i=1,ntypes
               read(12,*,end=6)tqt(i),oldqt(i)
        enddo
        close(12)
        do i=1,natom
          q(i)=123456
          do j=1,ntypes
            if(oldtypes(i) .eq. tqt(j)) then
                  q(i)=oldqt(j)
            endif
          enddo      
        enddo
       do i=1,natom
         if(q(i).eq.123456)then
          print *,'atom',i,'has no charge'
          stopit=.true.
       endif
        enddo
        if(stopit)then
         stop 'problems with charges'
        endif
      endif
            
      geometries=gcount(fg)      

c read geometries, energy
      allocate (xyz(natom*geometries,3))
      allocate (x(natom),y(natom),z(natom))
      allocate (atom(natom))      
      allocate (v(geometries),w(geometries),wdelta(geometries))
      allocate (wtol(geometries),wtype(geometries))
      allocate (r(geometries,natom,natom))
      open(11,file=fe,status="old",err=5)
      open(10,file=fg,status="old",err=5)
c  j= geometry
      do j=1,geometries
       read (10,*,end=2) na
       if(autoweights) then
         read(11,*,end=4) v(j),w(j),wtype(j),wtol(j),wdelta(j)
       else
         read (11,*,end=4) v(j), w(j)       
         wtype(j)=0
         wtol(j)=0
         wdelta(j)=0
       endif
c read each geometry
       if(na .ne. natom) then
             stop 'No enough coordinates'
       endif
       read (10,*)
        do i=1,natom
         read (10,*,end=3) atom(i),x(i),y(i),z(i)
         xyz((j-1)*natom+i,1)=x(i)
         xyz((j-1)*natom+i,2)=y(i)
         xyz((j-1)*natom+i,3)=z(i)
         if(atom(i).ne.symbol(i))then
          print *,'geometry:',j,'n:',i,' symbol:',atom(i),
     *            ' mismatch with ',symbol(i),' in ',
     *            fa2t,' or ',fg
          stop
         endif
        enddo
c packs all distances (due inter + intra changes)
        do i=1,natom
         do k=i,natom
c j=geometry, i=atom i, k=atom k
          if(k.eq.i) then
                 r(j,i,k)=0.0
          else
           r(j,i,k)=sqrt((x(i)-x(k))**2
     *                 +(y(i)-y(k))**2
     *                 +(z(i)-z(k))**2)
           r(j,k,i)=r(j,i,k)
          endif
         enddo
        enddo            
      enddo
      close(11)
      close(10)

c hook to user read subroutine in userpotential.f      
      call userread()
c hook to save all read data here
c     savealldata()
      return
   3  stop 'No enougth lines'
   2  stop 'No enougth geometries'
   4  stop 'No enougth energies or no enougth weigths'
   1  stop 'No enougth types'
   5  stop 'No coordinates or no energy file'
   6  stop 'No enougth charges'
      end                    
      
      function gcount(arquivo)
      use printoptions
      implicit none
      character(len=*) arquivo
c     character lx
      character atom*2
      real  x,y,z
      integer n,i,gcount
      gcount=0                               
      open(10,file=arquivo,status="old",err=5)
      do while (.true.)
       read (10,*,end=2)n
       if(fprtgeo) then
       print *,n
       endif
       gcount=gcount+1
       read (10,*)
       do i=1,n
        read (10,*,end=3) atom,x,y,z
        if(fprtgeo)then
         print *,atom,x,y,z
        endif
       end do
      end do
   3  stop 'Not enough coordinates'
   2  continue
      close(10)
      if(fprtgeo)then
        call flush(6)
      endif
      return
   5  stop 'No coordinates file'
      end

c interface Fortran/C functions      
      integer function getnprox()
      use vglobales
      getnprox=nprox
      end
      
      integer function getnsam()
      use vglobales
      getnsam=nsam
      end

      integer function getptypes()
      use vglobales
      getptypes=ptypes
      end
      
      integer function getstypes()
      use vglobales
      getstypes=stypes
      end
      
      integer function getctypes()
      use vglobales
      getctypes=ctypes
      end
     
      integer function getdtypes()
      use vglobales
      getdtypes=dtypes
      end 
      
      integer function getgeo()
      use vglobales
      getgeo=geometries
      end
      
      integer function getinteractions()
      use vglobales
      getinteractions=interactions
      end
     
      integer function getisuserint()
      use vglobales
      getisuserint=0
      if(userdefined) then
             getisuserint=1
      endif
      end

      integer function getisallint()
      use vglobales
      getisallint=0
      if(intratypes)then
       getisallint=1
      endif
      end

      integer function getpot()
      use vglobales
      getpot=potential
      end
      
      subroutine setpot(i)
      use vglobales
      integer i
      potential=i
      end
             
      integer function getncoefs()
      use vglobales
      getncoefs=coeficients
      end
      
      subroutine getatom(i,res)
      use vglobales
      character*3 res
      integer i
      res=atom(i)//char(0)
      end
      
      double precision  function getq(i)
      use vglobales
      integer i
      if(charges) then
      getq = q(i)
      else 
      getq = 0.0
      endif
      return
      end

      double precision function getoldq(i)
      use vglobales
      integer i,j
      getoldq=0.0
      if(charges) then
      do j=1,ptypes+stypes
            if(tqt(j).eq.i)then
              getoldq = oldqt(j)
              return
            endif
      enddo
      endif
      return
      end

      integer  function getotype(i)
      use vglobales
      integer i
      getotype=oldtypes(i)
      end

      integer  function getntype(i)
      use vglobales
      integer i
      getntype=types(i)
      end
      
      integer function needq()
      use vglobales
      if(charges) then
      needq=1
      else
      needq=0
      endif
      end

      integer function getgeom()
      use vglobales
      getgeom=geometries
      end

      double precision function getenergy(i)
      use vglobales
      integer i
      getenergy=v(i)
      end      

      double precision function getweight(i)
      use vglobales
      integer i
      getweight=w(i)
      end      
      
      double precision function curve(d,atom1,atom2,x,nmax)
      integer atom1,atom2,nmax
      double precision d,x(nmax),vpot
      call curRouter(d,atom1,atom2,x,nmax,vpot)
      curve=vpot
      end

      integer function setautow(i,k)
      use vglobales
      use printoptions
      integer i,k
      if(i.eq.0) then
      autoweights=.false.
      fprtauw=.false.
      else
      autoweights=.true.
       if(k.eq.0) then
         fprtauw = .false.
       else
         fprtauw = .true.
       endif
      endif
      setautow=1
      return
      end
      
      integer function getautow()
      use vglobales
      if(autoweights)then
      getautow=1
      else
      getautow=0
      endif
      return
      end

      integer function getautoprt()
      use printoptions
      if(fprtauw)then
      getautoprt=1
      else
      getautoprt=0
      endif
      return
      end
                    
      subroutine coordinates(geo,index,xx,yy,zz)
      use vglobales
      integer geo,index
      double precision xx,yy,zz
      xx=xyz((geo-1)*natom+index,1)
      yy=xyz((geo-1)*natom+index,2)
      zz=xyz((geo-1)*natom+index,3)
      return
      end

c counts distincts values in a integer vector tocount(nt) from ni to nf      
      integer function ncounter(nt,ni,nf,tocount)
      integer nt,ni,nf,tocount(nt)
      integer t(nf-ni+1),in,number,ran
      integer i,j
      in=1
      do i=ni,nf
       t(in)=tocount(i)
       in=in+1
      enddo
      ran=nf-ni+1

      number=0
      do i=1,ran
            if(t(i).gt.0) then
              number=number-1
              do j=i+1,ran
                if(t(i).eq.t(j))then
                  t(j)=number
                endif
              enddo
              t(i)=number
            endif            
      enddo
      
      ncounter=0
      do i=1,ran
       if(ncounter.gt.t(i)) then
         ncounter=t(i)
       endif
      enddo      
      ncounter=-ncounter
      return
      end

c count how many types have more than one atom
      integer function ndupl(nt,tocount)
      integer i,j,nt,tocount(nt)
      ndupl=0
      do i=1,nt  
      do j=i+1,nt
         if(tocount(i).eq.tocount(j)) then
            ndupl=ndupl+1
            exit
         endif
      enddo
      enddo
      end

c detects types with more than one atom
      logical function isdupl(i,nt,tocount)
      integer i,j,nt,tocount(nt)
      isdupl=.false.
      do j=1,nt
        if((j.ne.i).and.(tocount(i).eq.tocount(j)))then
                isdupl=.true.
c     print *,'duplicado:',i
                exit
        endif
      enddo
      end

