/*
 (c)GAFit toolkit $Id: final.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include "final.h"
#include "interface.h"
#include "../inputline/line.h"
#include "../analytical/analytical.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../cnames.h"



void
PrintCoefficients (FILE * outfile, double *x, int types, int ncoefs, int np,
		   int ns)
{
  int i, j, k, l, zero, c, bus;
  int charges;
  float qi = 0, qj = 0;
  char at1[10], at2[10];
  charges = NeedQ ();
  for (j = 0; j < types; j++)
    {
      for (i = 0; i < ncoefs; i++)
	{
	  if ((j * ncoefs + i) % ncoefs == 0)
	    {
	      bus = j * ncoefs + i + 1;
	      zero = 1;
	      fprintf (outfile, "\n");
	      fprintf (outfile, "INTERACTION TYPE %d\n", bus / ncoefs + 1);
	      fprintf (outfile, "----------------------\n");
	      if (!GetIsUserInteractions ())
		{
		  int nlast, nfirst;
		  c = 0;
		  if (GetIsAllInteractions ())
		    nlast = np + ns;
		  else
		    nlast = np;
		  for (k = 1; k <= nlast; k++)
		    {
		      GetAtom (&k, at1);
		      sRtrim (at1);
		      if (GetIsAllInteractions ())
			nfirst = k + 1;
		      else
			nfirst = np + 1;
		      for (l = nfirst; l <= ns + np; l++)
			{
			  GetAtom (&l, at2);
			  sRtrim (at2);
			  if (IndexType (&k, &l, &zero) == bus)
			    {
			      fprintf (outfile, "%s(%d)-%s(%d) ", at1, k,
				       at2, l);
			      c++;
			      if (c % 6 == 0)
				fprintf (outfile, "\n");
			      if (charges)
				{
				  qi = GetQ (&k);
				  qj = GetQ (&l);
				}
			    }
			}
		    }
		  if (charges)
		    fprintf (outfile, "\n\n\tqi=%+15.5lf\n\tqj=%+15.5lf\n",
			     qi, qj);
		}
	      fprintf (outfile, "\n\tCoefficients:\n");

	    }
	  if (GetPot ())
	    {
	      fprintf (outfile, "\t%5d %s %+20.10lf\n",
		       j * ncoefs + i + 1,
		       CoefName ((j * ncoefs + i) % ncoefs),
		       x[j * ncoefs + i]);
	    }
	  else
	    fprintf (outfile, "\t%5d %10s %+20.10lf\n",
		     j * ncoefs + i + 1,
		     CoefName ((j * ncoefs + i) % ncoefs), x[j * ncoefs + i]);
	}
    }
}

void
FinalEvaluation (FILE * outfile, int N, int prt, double *best)
{
  double *x, cvalue, vvalue, weight;
  int i, ndi, ncoefs, np, ns, nxeo, m;
  int index;
  ndi = GetInteractions ();
  ncoefs = GetNCoefs ();
  np = GetNProx ();
  ns = GetNSam ();
  nxeo = GetGeom ();
  m = N;

  if (!best)
    x = LoadBest (OUTPUT_BEST, N);
  else
    x = best;
  if (prt)
    {
      fprintf (outfile, "\n\n#\n#Results\n#\n");
      PrintCoefficients (outfile, x, ndi, ncoefs, np, ns);
    }
  fprintf (outfile, "#\n#Evaluation\n");
  fprintf (outfile, "#\n");
  fprintf (outfile,
	   "#Geometry     Energy        Calculated      Difference     Weight\n");
  fprintf (outfile,
	   "#========     ======        ==========      ==========     ======\n");
  for (i = 0; i < nxeo; i++)
    {
      index = i + 1;
      cvalue = EvalGeo (x, &m, &index);
      vvalue = GetEnergy (&index);
      weight = GetWeight (&index);
      fprintf (outfile, " %5d   %+15.12f  %+15.12f  %+6.2f %%      %+6.2lf\n",
	       index, vvalue, cvalue, (cvalue - vvalue) / vvalue * 100,
	       weight);
    }
  if (!best)
    free (x);
}

double *
LoadBest (char *filename, int howmany)
{
  FILE *best;
  double *x;
  int i;
  x = (double *) malloc (sizeof (double) * howmany);
  if ((best = fopen (OUTPUT_BEST, "rt")) != NULL)
    {
      for (i = 0; i < howmany; i++)
	{
	  fscanf (best, "%lf\n", &x[i]);
	}
      fclose (best);
    }
  return x;
}
