/*
(c) GAFit toolkit $Id: common.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../core.h"
#include "../environ/environ.h"
#include "../rstrings/rstrings.h"
#include "../flyctl/flyctl.h"
#include "../inputline/line.h"
#include "intpot.h"
#include "../job.h"
#include "interface.h"

char *ToolsOutput = NULL;


void
printSepBar (FILE * f)
{
  fprintf (f, "--------------------------------\n");
}

void
InitEnvironmentVariables (JOB * job)
{
  job->external_input = SetEnv ("EXTERNAL_INPUT", EXTERNAL_INPUT);
  job->external_fit = SetEnv ("EXTERNAL_FIT", EXTERNAL_FIT);
  job->external_bounds = SetEnv ("BOUNDS_FILE", BOUNDS_FILE);
  ToolsOutput = sLowerCase (SetEnv ("TOOLS_OUTPUT", TOOLS_OUTPUT));
}

void
PrepareSystem (JOB * jo, int prt)
{
  jo->bounds = ReadJobInternal (jo, prt);
}

//autoconfigure
void
WriteResponse (JOB * job)
{
  FILE *r;
  char *nwbounds;
  nwbounds = MakePath (job->external_bounds, ".internal");
  r = fopen ("response", "w");
  printf ("-----------------------------------------------\n");
  if (!r)
    {
      printf ("Cannot open file 'response'\n");
      fcStopIt ("error intpot 'response'\n");
    }
  fprintf (r, "\n");
  fprintf (r, "[job]\n");
  fprintf (r, "type: external bulk\n");	//cambiar a external bulk
  fprintf (r, "coefficients: %d\n", job->N);
  fprintf (r, "external input: %s\n", job->external_input);
  fprintf (r, "external fit: %s\n", job->external_fit);
  fprintf (r, "bounds: %s\n", nwbounds);
  fprintf (r, "final evaluation: yes\n");
  fprintf (r, "\n");
  fclose (r);
  free (nwbounds);
  return;
}

void
ReadInputVector (int indv, JOB * jo, p_ind population)
{
  int j, i, r;
  char *s;
  FILE *f;
  f = fopen (jo->external_input, "r");
  if (f)
    {
      for (j = 0; j < indv; j++)
	{
	  for (i = 0; i < jo->N; i++)
	    {
	      s = InputFileLine (f);
	      if (!s)
		{
		  printf ("Error!\n");
		  fcStopIt ("No input in file jo->external_input\n");
		}
	      r = sscanf (s, "%lf", &population[j].genes[i]);
	      if (r == 0)
		fcStopIt ("Error reading External Input\n");

	      free (s);
	    }
	  s = InputFileLine (f);
	  free (s);
	}
      fclose (f);
    }
  else
    {
      printf ("No file %s\n", jo->external_input);
      fcStopIt ("No file jo->external_input\n");
    }
}

void
WriteFit (int indv, JOB * job, p_ind pop)
{
  FILE *f = fopen (job->external_fit, "w");
  if (f)
    {
      for (int i = 0; i < indv; i++)
	{
	  fprintf (f, "%lf\n", pop[i].fitness);
	}
      fclose (f);
    }
  else
    fcStopIt ("cannot write external.fit");
}

void
RunEvaluation (int indv, JOB * jo)
{
  p_ind population = malloc (sizeof (ind) * indv);	//indv=jo->pop_size si bulk
  for (int i = 0; i < indv; i++)
    population[i].genes = malloc (sizeof (double) * jo->N);	//coefs=jo->N
  ReadInputVector (indv, jo, population);
  for (int i = 0; i < indv; i++)
    {
      eval_f (population[i].genes, &jo->N, &population[i].fitness);
    }
  WriteFit (indv, jo, population);
  for (int i = 0; i < indv; i++)
    free (population[i].genes);
  free (population);
}
