/*
  (c)GAFit toolkit $Id: bounds.c 510 2025-04-22 14:23:13Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "interface.h"
#include "../inputline/line.h"
#include "../core.h"
#include "../numbers.h"
#include "../analytical/analytical.h"
#include "../literals/literals.h"
#include "../rstrings/rstrings.h"
#include "../cnames.h"
#include "bounds.h"

//extern int jobtype;

void
ReadBounds (domain * v, const char *file, int coefs, int inter)
{
  char *s;
  FILE *f;
  int n = 0;
  int r, l;
  int lines;
  coefs += 1;			//plus text line per each coefs set.
  lines = coefs * inter;
  f = fopen (file, "r");
  if (f)
    {
      l = 0;
      while ((s = InputFileLine (f)) != NULL)
	{
	  l++;
	  if (l - 1 > lines)
	    break;
	  if ((n) % coefs)
	    {
	      r = sscanf (s, "%lf %lf %d", &v->min, &v->max, &v->decimals);
	      if (r < 3)
		{
		  printf ("Bounds - Error reading line %d, text:'%s'.\n", l,
			  s);
		  printf ("         Expected min max decimals\n");
		  exit (EXIT_FAILURE);
		}
	      v->gap = v->max - v->min;
	      v++;
	    }
	  free (s);
	  n++;
	}
      free (s);
      fclose (f);
    }
  else
    {
      printf ("Bounds - File not found: %s\n", file);
      exit (EXIT_FAILURE);
    }
  if (lines > l)
    {
      printf ("Bounds - Error, short read, expected %d, found %d lines.\n",
	      lines, l);
      exit (EXIT_FAILURE);
    }
}

void
PrintCoefNames (vect_domain bounds, int ncoefs, int i, int j)
{
  char *clet = Letters ((j * ncoefs + i) % ncoefs);

  printf ("\t%5d %10s %+15.5lf - %+15.5lf (%s)\n",
	  j * ncoefs + i + 1,
	  CoefName (((j * ncoefs + i) % ncoefs)),
	  bounds[j * ncoefs + i].min, bounds[j * ncoefs + i].max,
	  ii (bounds[j * ncoefs + i].decimals));
  free (clet);
}


void
PrintBounds (vect_domain bounds, int types, int ncoefs, int np,
	     int ns, int first, int last)
{
  int i, j, k, l, zero, c, bus;
  int charges;
  float qi = 0, qj = 0;
  char at1[10], at2[10];
  charges = NeedQ ();
  if (first < 1)
    first = 1;
  if (last > types)
    last = types;
  for (j = first - 1; j < last; j++)
    {
      for (i = 0; i < ncoefs; i++)
	{
	  if ((j * ncoefs + i) % ncoefs == 0)
	    {
	      bus = j * ncoefs + i + 1;
	      zero = 1;
	      printf ("INTERACTION TYPE %d\n", bus / ncoefs + 1);
	      printf ("----------------------\n");
	      if (!GetIsUserInteractions ())
		{
		  int nlast, nfirst;
		  c = 0;

		  //for (k = 1; k <= np; k++) 
		  //for (k = 1; k <= np + ns; k++)

		  if (GetIsAllInteractions ())
		    nlast = np + ns;
		  else
		    nlast = np;

		  for (k = 1; k <= nlast; k++)
		    {
		      GetAtom (&k, at1);
		      sRtrim (at1);
		      //for (l = np + 1; l <= ns + np; l++)
		      //for (l = k + 1; l <= ns + np; l++)
		      if (GetIsAllInteractions ())
			nfirst = k + 1;
		      else
			nfirst = np + 1;

		      for (l = nfirst; l <= ns + np; l++)
			{
			  GetAtom (&l, at2);
			  sRtrim (at2);
			  if (IndexType (&k, &l, &zero) == bus)
			    {
			      printf ("%s(%d)-%s(%d) ", at1, k, at2, l);
			      c++;
			      if (c % 6 == 0)
				printf ("\n");
			      if (charges)
				{
				  qi = GetQ (&k);
				  qj = GetQ (&l);
				}
			    }
			}
		    }
		  if (charges)
		    printf ("\n\n\tqi=%+15.5lf\n\tqj=%+15.5lf\n", qi, qj);
		}

	      printf ("\n\tCoefficients:\n");
	    }
	  PrintCoefNames (bounds, ncoefs, i, j);
	}
    }
}
