/*
(c) GAFit toolkit $Id: line.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

ssize_t
InputLine (char **lineptr, size_t *n, int delim, FILE * stream)
{
  ssize_t l;
  char *ll;
  l = getdelim (lineptr, n, delim, stream);
  ll = *lineptr;
  if (l > 0)
    {
      if (ll[l - 1] == '\n')
	ll[l - 1] = '\0';

      if (l > 1)
	{
	  if (ll[l - 2] == '\r')
	    ll[l - 2] = '\0';
	}
    }
  return l;
}


char *
InputFileLine (FILE * f)
{
  char *line = NULL;
  size_t n = 0;
  ssize_t l = 0;
  l = InputLine (&line, &n, '\n', f);
  if (l < 0)
    {
      free (line);
      return NULL;
    }
  return line;
}

char *
InputFileText (FILE * f)
{
  char *text = NULL;
  char *ntext = NULL;
  char *l = NULL;
  int len = 0;
  while ((l = InputFileLine (f)))
    {
      if (text)
	len = strlen (text);
      else
	len = 0;
      len = len + strlen (l) + strlen ("\n") + 1;
      ntext = (char *) malloc (len * sizeof (char));
      if (text)
	ntext = strcpy (ntext, text);
      else
	ntext[0] = '\0';
      ntext = strcat (ntext, l);
      ntext = strcat (ntext, "\n");
      free (text);
      free (l);
      text = ntext;
    }
  return text;
}

char *
InputStdinLine (void)
{
  return InputFileLine (stdin);
}

char *
MakePath (char *path, char *suff)
{
  char *rpath;
  rpath = (char *) malloc (strlen (path) + strlen (suff) + 1);
  strcpy (rpath, path);
  strcat (rpath, suff);
  return rpath;
}

int
FileExist (char *p)
{
  struct stat buf;
  if (stat (p, &buf))
    return 0;
  return 1;
}

long long
FileSize (char *p)
{
  struct stat buf;
  if (stat (p, &buf))
    return 0;
  return (long long) buf.st_size;
}
