#include "core.h"
#include "job.h"
#include "selection.h"
#include "crossover.h"
#include "mutation.h"
#include "evaluation.h"
#include "utils.h"
#include "genetic.h"

int
genetic (JOB * jo)
{
  int evaluations;
  ind dummy;
      /************************* GENETIC ALG ********************/
  // tournament selection
  tournament_selection (jo);

  // applies genetic operators
  apply_crossover (jo);
  apply_mutation (jo);

  // evaluate populations
  evaluations = evaluate_NewPop (jo);

  // GA simples
  swapPopulation (jo);

  // Get best from new generation
  dummy = get_best (jo);
  copia_ind (&dummy, &jo->new_best, jo->N);

  if (jo->ga.elite)
    {
      if (jo->dir == 1)
	{
	  if (jo->new_best.fitness < jo->best.fitness)
	    {
	      apply_elite (jo, jo->best);
	    }

	  else if (jo->new_best.fitness > jo->best.fitness)
	    {
	      copia_ind (&jo->new_best, &jo->best, jo->N);
	    }

	}

      else
	{
	  if (jo->new_best.fitness > jo->best.fitness)
	    {
	      apply_elite (jo, jo->best);
	    }

	  else if (jo->new_best.fitness < jo->best.fitness)
	    {
	      copia_ind (&jo->new_best, &jo->best, jo->N);
	    }
	}
    }
      /********************GENETIC ALG ******^***********/
  return evaluations;
}
