/*
(c) GAFit toolkitk $Id: templanalyzer.c 505 2025-01-25 02:06:51Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../flyctl/flyctl.h"
#include "../rangecf/rangecf.h"
#include "common.h"

extern char *ExternalInput;
extern char *ExternalFit;
extern char *Bounds;
extern char *InputTemplate;

char *ExternalType = EXTERNAL_TYPE_BULK;


void
usage (char *cmd)
{

  printf ("\ntemplate analyzer v0.1 (c)GAFit toolkit - 2018\n");
  printf ("\tUsage: %s [template ...]\n\n", cmd);

  fcStopIt ("template analyzer error\n");
}


int
main (int argc, char **argv)
{
  //int indv;
  RANGECOEFS *rc;

  fcStartFly ();

  InitEnvironmentVariables ();

  if (argc > 1)
    {
      //command line overwrites environment variable
      int size = 0;

      InputTemplate[0] = 0;	//initialized in InitEnvironmentVariables
      for (int i = 1; i < argc; i++)
	{
	  size += strlen (argv[i]) + 2;
	  InputTemplate = realloc (InputTemplate, size);
	  strncat (InputTemplate, argv[i], strlen (argv[i]));
	  strcat (InputTemplate, " ");
	}
    }
  //create a new template from many pieces of text
  InputTemplate = MergeTemplates (InputTemplate);
  if ((rc = rcAnalyzeTemplate (InputTemplate, ANALYSIS_RESULTS_FILE)) == NULL)
    {
      fcStopIt ("Analyze Template error\n");
    }

  if (!rcWriteResponse (rc, ExternalType, ExternalInput, ExternalFit, Bounds))
    {
      fcStopIt ("Analyze Template Response file error\n");
    }

  if (!rcWriteBounds (rc, Bounds, InputTemplate))
    {
      fcStopIt ("Bounds error");
    }

  rcTemplateClean (rc);

  newFile (ALL_TEXT_RESULTS);
  newFile (RAW_INTERMEDIATE_RESULTS);
  return 0;
}
