
/*
(c) GAFit toolkitk $Id: gfitter.c 558 2025-11-30 01:00:26Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "../environ/environ.h"
#include "../flyctl/flyctl.h"
#include "../literals/literals.h"
#include "common.h"

extern char *RefValuesFile;
extern char *RawFitsFile;
extern char *RawResultsFile;


void
usage (void)
{
  printf ("genericfitter v0.1 (c)GAFit toolkit - 2019\n");
  printf ("\tUsage: genericfitter letter filedata\n\n");
  exit (EXIT_SUCCESS);
}

int
main (int argc, char **argv)
{
  double *results;
  double *data;
  //double *references;
  REFERENCEVALUES **references;
  double fit = 0;
  int nletter;
  int n, m;

  InitEnvironmentVariables ();

  if (argc != 3)
    {
      usage ();
    }
  else
    {
      data = (double *) dlist (argv[2], &n);
      references = rvlist (RefValuesFile, &m);

      nletter = Srettel (argv[1]);
      if (n != m)
	fcPrintfStopIt ("genericfitter: %d data != %d references, %s\n", n, m,
			argv[1]);
      results = malloc (sizeof (double) * n);
      for (int i = 0; i < n; i++)
	{
	  results[i] = references[i]->value - data[i];
//	    printf("ref value=%lf - data=%lf = result=%lf weight=%lf\n",references[i]->value,data[i],results[i],references[i]->weight);
	  fit += results[i] * results[i] * references[i]->weight;
	}
      fit = sqrt (fit);
//      printf("fit:%lf\n",fit);
      WriteFit (RawFitsFile, nletter, fit);
      WriteResults (RawResultsFile, nletter, n, data);
      return 0;
    }
}
