/*
(c) GAFit toolkit $Id: common.h 505 2025-01-25 02:06:51Z ro $
*/

#ifndef _GENERIC_INTERFACE_
#define _GENERIC_INTERFACE_

#define EE_NOT_SET "external executable NOT SET"
#define EXTERNAL_INPUT "external.input"
#define EXTERNAL_FIT "external.fit"
#define BOUNDS_FILE      "bounds.txt"
#define INPUT_TEMPLATE "template"
#define MERGED_TEMPLATES "tmp-template"
#define PARALLEL_CALCS "1"
#define EXTERNAL_EXECUTABLE EE_NOT_SET
#define EXTERNAL_TYPE_BULK "external bulk"
#define GENERIC_COMMANDLINE_MAX 255
#define GENERIC_COMMAND_EXEC "execxxx"
#define REFERENCE_VALUES "reference.values"
#define INPUT_EXT ".input"

#define RAW_FITS "rawfits.bin"
#define RAW_RESULTS "rawresults.bin"
#define ALL_TEXT_RESULTS "report_best.txt"
#define RAW_INTERMEDIATE_RESULTS "rawall.bin"

#define STR_EXTERNAL_INPUT "EXTERNAL_INPUT"
#define STR_EXTERNAL_FIT "EXTERNAL_FIT"
#define STR_BOUNDS_FILE      "BOUNDS_FILE"
#define STR_INPUT_TEMPLATE "INPUT_TEMPLATE"
#define STR_PARALLEL_CALCS "N_CORES"
#define STR_EXTERNAL_EXECUTABLE "EXTERNAL_EXECUTABLE"
#define STR_INPUT_EXT "INPUT_EXT"
#define STR_REF_VALUES "REFERENCE_VALUES"
#define STR_RAW_FITS "RAW_FITS_FILE"
#define STR_RAW_RESULTS "RAW_RESULTS_FILE"
#define STR_REF_VAL_FILE "REFERENCE_VALUES_FILE"

#define SNPRINTF 200
#define MAXSTR 4096

#define SIMPLE_BAR "|              "
#define PDOUBLE    "| %12lg "
#define PINT       "| %12d "
#define PEND       "|\n"
#define PEMPTY     "               "
#define PLINE      "+--------------"
#define PLIND      "+\n"
#define PHEAD     "| %12s "
#define PNHEAD    "| %*s%*s%*s   "
#define PHEADER   "%s (%3d)"
#define PSPACE    " "

#define NODUPS 1
#define YESDUPS 0
#define YESLIMIT 1
#define NOLIMIT 0

#include "../rangecf/rangecf.h"
typedef struct refval
{
  double value;
  double weight;
  char *name;
} REFERENCEVALUES;

typedef struct resval
{
  double *coefs;		//ncoefs coefficients
  double *values;		//nvalues result values
  double fit;			//fit
  double distance;		//distance from best 
} RESULTVALUES;

typedef struct allresults
{
  int ncoefs;			//number of coefficients
  int nvalues;			//number of reference values to compare
  int nindiv;			//number of individuals
  int nresults;			//number of results loaded.
  int limit;			//max number of results
  char **coefsnames;		//ncoefs coefficient names
  REFERENCEVALUES **references;	//nvalues reference values
  RESULTVALUES **results;	//nresulsts RESULTVALUES structures
} ALLRESULTS;

void InitEnvironmentVariables (void);
char *MergeTemplates (char *list);
void writeAnalysisResults (char *outTemplate);
int readAnalysisResults (void);
void printAll (void);
int WriteInputFile (char *content, char *file, char *templateName);
char *CreateParameters (char *t, double *coefs, int nc);
char **SplitTemplates (char *list);
double *dlist (char *fname, int *n);
REFERENCEVALUES **rvlist (char *fname, int *n);
void WriteFit (char *file, int pos, double value);
void WriteResults (char *file, int pos, int n, double *value);
REFERENCEVALUES **getNRefs (char *fname, int *n);
double *ReadResults (char *file, int n, int m);
char *TextResults (void);
char *newFile (char *file);
void WriteTextResults (char *file, ALLRESULTS * all);
void printAllResults (FILE * f, ALLRESULTS * all, int nodups, int yeslimit);
ALLRESULTS *loadNewResults (int nindv, int nvalues, RANGECOEFS * rc,
			    double **coefficients, double *results,
			    double *fits, REFERENCEVALUES ** rv);
ALLRESULTS *ReadIntermediateResults (char *file, ALLRESULTS * all);
void WriteIntermediateResults (char *file, ALLRESULTS * all);
ALLRESULTS *sortAll (ALLRESULTS * all);
ALLRESULTS *sortAllD (ALLRESULTS * all);
ALLRESULTS *applyPercentile (ALLRESULTS * all);
ALLRESULTS *calcDist (ALLRESULTS * all);
#endif
