/*
(c) GAFit toolkit $Id: fpu.h 24 2015-02-10 23:50:10Z ro $
*/
#ifndef __FPU_DEFS__
#define __FPU_DEFS__

#define FPU_ERROR 	1	//0b000000000001
#define FPU_STACKEMPTY	2	//0b000000000010
#define FPU_BADADDR 	4	//0b000000000100
#define FPU_NOTINT 	8	//0b000000001000
#define FPU_INSTRERROR  16	//0b000000010000
#define FPU_MATHERR  	32	//0b000000100000
#define FPU_DIVBYZERO 	64	//0b000001000000
#define FPU_INVALID 	128	//0b000010000000
#define FPU_UNDERFLOW 	256	//0b000100000000
#define FPU_OVERFLOW 	512	//0b001000000000

typedef struct
{
  double **AddrStack;
  int StackPointer;
  int FpuFlags;
  int ProgramCounter;
} FPU_RUNTIME;

typedef struct
{
  void *Program;
  int ProgramLen;
  double **MemoryPool;
  int MemoryCount;
  int MemoryProtect;		//memory count passed initiallly. Not freed by fpuClear!
  double *StackTop;
} FPU2011;


void fpuPrintMemory (FPU2011 * u);
void fpuPrintMemoryLabels (FPU2011 * u, char **vars, int nvars);
void fpuMemoryBlockAdd (FPU2011 * u, double *mblock, int size);
void fpuAddVariable (FPU2011 * u, double variable);
void fpuReset (FPU2011 * fpu);
void fpuClear (FPU2011 * fpu);
void fpuLoad (FPU2011 * fpu, char *file);
void fpuStatus (int flags);
void fpuExplainStatus (int flags);
FPU2011 *fpuNew (void);
int fpu2011 (FPU2011 * run);
double fpuGetVariable (FPU2011 * u, int index);
#endif
