/*
(c) GAFit toolkit $Id: flyctl.c 399 2021-11-11 16:05:09Z ro $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include "flyctl.h"
#include "../inputline/line.h"

void
fcStopIt (char *reason)
{
  FILE *f;
  f = fopen (CTLFILE, "w");
  fwrite (reason, sizeof (char), strlen (reason), f);
  fclose (f);
  printf (">>%s\n", reason);
  exit (EXIT_FAILURE);
}

void
fcStartFly (void)
{
  unlink (CTLFILE);
}

void
fcCStopIt (char *s, long n)
{
  fcStopIt (s);
}

void
fcCheck (void)
{
  FILE *f;
  char s;
  if (FileExist (CTLFILE))
    {
      printf ("%s exists!\n", CTLFILE);
      f = fopen (CTLFILE, "r");
      printf ("\n");
      while (!feof (f))
	{
	  fread (&s, 1, 1, f);
	  printf ("%c", s);
	}
      printf ("\n");
      exit (EXIT_FAILURE);
    }
}

void
fcPrintfStopIt (char *format, ...)
{
  va_list args;
  char buffer[BUFFSIZE];

  va_start (args, format);
  vsnprintf (buffer, BUFFSIZE - 1, format, args);
  va_end (args);
  fcStopIt (buffer);
}
